#ifndef FLASHPATCHER_H
#define FLASHPATCHER_H

#include <apps.h>
#include <uis.h>

#define BLOCK_SIZE      0x20000               //   128 
#define COUNT_SEGMENT   2                        // -   
#define SEGMENT_SIZE    0x10000     // BLOCK_SIZE/COUNT_SEGMENT //  
                                                 // 
typedef struct{
    UINT8   *segment[COUNT_SEGMENT];
} BLOCK_T;

typedef enum {
    PATCH_OK,
    PATCH_FAIL,
    PATCH_MEM_FAIL

}RESULT_PATCH_T;

/*    .      */
typedef struct
{ 
    APPLICATION_T           apt; /*   ,   */

    /*      */
    /* ... */

} APP_FLASHPATCHER_T;

/*   */
typedef enum
{
    FP_STATE_ANY, /* ANY-state   */

    FP_STATE_INIT,
    FP_STATE_MAIN,
    FP_STATE_MSG,


    FP_STATE_MAX /*   */
} FP_STATES_T;

typedef enum
{
    RES_ACTION0,
    RES_ACTION1,
    RES_ACTION1_CAPTION,
	
	RES_MAX
} SHELL_RESOURCE;


UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );

UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app );

UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 MsgStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 usePatch( EVENT_STACK_T *ev_st,  void *app );
UINT32 useUndo( EVENT_STACK_T *ev_st,  void *app );
void makeUndo(void);
UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );

UINT32 InitResources(void);
UINT32 RemoveResources(void);
UINT32 OneAction( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res, UINT8 op );
UINT32 ActionAdd( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res );
UINT32 ActionUpd( ACTIONS_T * list, EVENT_CODE_T event, RESOURCE_ID res );

UINT32 CopyBlock(UINT32 adr, BLOCK_T *block);
void FreeBlock(BLOCK_T *block);
UINT32 WriteBlock(UINT32 adr, BLOCK_T block);
BYTE SetValue(BLOCK_T *block, UINT32 adr, BYTE value);
UINT32 getBlockAdr(UINT32 adr);

char* dec2hex( UINT32 dec, char *hex, UINT16 size );

UINT32 util_asc2ul( const char * s, UINT32 count );
UINT32 param2uri(char *param, WCHAR *uri);

#endif