#include "INIparser.h"
#include <dbg.h>

char            *bufR=NULL;
char            separator='=';

UINT32 OpenINI(WCHAR *uri) 
{
    FILE_HANDLE_T   ini;
    UINT32          fSize;
    INT32           er;
   
    ini = DL_FsOpenFile(uri, FILE_READ_MODE, 0);
    if (ini == FILE_INVALID) return RESULT_FAIL;

    fSize = DL_FsGetFileSize(ini);
    bufR = (char*) suAllocMem( fSize+2, &er );
    if (er != 0) return RESULT_FAIL;

    bufR[0] = ' ';
    DL_FsReadFile( bufR+1, 1, fSize, ini, &fSize );
    bufR[fSize+1] = 0;
    DL_FsCloseFile(ini);

    dbg("open ini file", NULL);

    return RESULT_OK;
}


void CloseINI(void) {
     free(bufR);
}

void setSeparator(char sep) {separator = sep;}
void setBuffer(char *buf) {
	free(bufR);
	bufR = buf;
}


BOOL ReadParamINI( char * param_name, char * value_buf, UINT32 buf_size, const char * default_value )
{
    char    *offset;
    BOOL    val=false;
    UINT32  i=0;

    if (bufR == NULL) {
        strcpy(value_buf, (char*)default_value);
        return RESULT_FAIL;
    }

    offset = strstr(bufR, param_name);
    if (offset == bufR) {
        dbg("param no find", NULL);
        strcpy(value_buf, (char*)default_value);
        return RESULT_FAIL;
    }

    offset += strlen(param_name)-1;

    while (*offset != 0x0A && *offset != 0) {
        offset++;
        if (val == false) {
            if (*offset == separator ) val = true;
        } else {
            if (*offset <= ' ') continue; // 
            if (i >= buf_size) return RESULT_OK;
   
            value_buf[i] = *offset;
            value_buf[i+1] = 0;
            i++;
        }
    }

    return RESULT_OK;
}
	
