#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=..\res\kos.ico
#AutoIt3Wrapper_outfile=..\KosEditor.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Res_Description=    Kosilka
#AutoIt3Wrapper_Res_Fileversion=1.0.0.0
#AutoIt3Wrapper_Res_LegalCopyright= 2010 Cool-T Labs
#AutoIt3Wrapper_Res_Language=1049
#AutoIt3Wrapper_Res_requestedExecutionLevel=asInvoker
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#cs ----------------------------------------------------------------------------

 AutoIt Version: 3.3.2.0
 Author:         myName

 Script Function:
	Template AutoIt script.

#ce ----------------------------------------------------------------------------
#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <ButtonConstants.au3>

Global $hWnd = GUICreate("Kosilka", 10*32, 10*32)
Global $hButtons[10][10], $dwStates[10][10], $dwLines[10]
Global $i, $j, $n, $k, $buf, $dwTrans = 255

Global Const $c = 0x3, $b = 0x2, $g = 0x1

For $i = 0 To 9
	For $j = 0 To 9
		$hButtons[$i][$j] = GUICtrlCreateButton("", $j*32, $i*32, 32, 32, BitOR($BS_CENTER, $BS_VCENTER))
		GUICtrlSetBkColor($hButtons[$i][$j], 0xFFFF00)
		$dwStates[$i][$j] = 1
	Next
Next

HotKeySet("{UP}", "_IncTrans")
HotKeySet("{DOWN}", "_DecTrans")

GUISetState(@SW_SHOW)

While True
	$uMsg = GUIGetMsg()
	Switch $uMsg
		Case $GUI_EVENT_CLOSE
			ExitLoop
		Case $GUI_EVENT_SECONDARYDOWN
			$szFile = FileSaveDialog("Save level", @DesktopDir, "Kosilka levels (*.dat)", 16, "level1.dat", $hWnd)
			if @error Then ContinueLoop
			$hFile = FileOpen($szFile, 2+16)
			For $i = 0 To 9
				For $j = 0 To 9
					Switch $dwStates[$j][$i]
						Case 0
							FileWrite($hFile, "0x03")
						Case 1
							FileWrite($hFile, "0x01")
						Case 2
							FileWrite($hFile, "0x02")
					EndSwitch
				Next
			Next
			FileClose($hFile)
			MsgBox(64, "Kosilka", "Data has been written to file", 1)
			For $i = 0 To 9
				For $j = 0 To 9
					GUICtrlSetBkColor($hButtons[$i][$j], 0xFFFF00)
					$dwStates[$i][$j] = 1
				Next
			Next
		Case Else
			For $i = 0 To 9
				For $j = 0 To 9
					If $uMsg = $hButtons[$i][$j] Then
						Switch $dwStates[$i][$j]
							Case 0
								$dwStates[$i][$j] = 1
								GUICtrlSetBkColor($hButtons[$i][$j], 0xFFFF00)
							Case 1
								$dwStates[$i][$j] = 2
								GUICtrlSetBkColor($hButtons[$i][$j], 0xFF0000)
							Case 2
								$dwStates[$i][$j] = 0
								GUICtrlSetBkColor($hButtons[$i][$j], 0x000000)
						EndSwitch
					EndIf
				Next
			Next
	EndSwitch
WEnd

GUIDelete($hWnd)

Func _IncTrans()
	Switch $dwTrans
		Case 0 To 247
			$dwTrans += 8
			WinSetTrans($hWnd, Default, $dwTrans)
	EndSwitch
EndFunc

Func _DecTrans()
	Switch $dwTrans
		Case 8 To 255
			$dwTrans -= 8
			WinSetTrans($hWnd, Default, $dwTrans)
	EndSwitch
EndFunc