#include "sysinfo.h"

UINT32              evcode_base;



FILE_HANDLE_T f;

const char app_name[APP_NAME_LEN] = "sysinfo"; 

BOOL bPressStar = FALSE;

const EVENT_HANDLER_ENTRY_T any_state_handlers[] = {  
    
	 { EV_KEY_PRESS,             HandleKeypress },
    { EV_KEY_RELEASE,           HandleKeyrelease },


 
    {	STATE_HANDLERS_END,           NULL       },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] ={
    
	{ 	STATE_HANDLERS_END,           NULL       },

};


static const STATE_HANDLERS_ENTRY_T state_handling_table[] ={
    
	{ 
		HW_STATE_ANY,             
      	NULL,                      
      	NULL,                     
      	any_state_handlers         
    },

    { 
		HW_STATE_MAIN,
      	MainStateEnter,
      	NULL,
      	main_state_handlers
    }

};

UINT32 Register( char* file_uri,  char* param,  UINT32 reserve ){
    
	UINT32 status = RESULT_OK;
    
	evcode_base = reserve; 
    

	status = APP_Register( 
							&evcode_base,        
                           	1,                   
                           	state_handling_table, 
                           	HW_STATE_MAX,          
                           	(void*)SysInfoStart 
	); 
    						
                   
    LdrStartApp(reserve);  

    return 1; 
}

UINT32 SysInfoStart( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 ){
    
	APP_SYSINFO_T     *app = NULL;
    
	UINT32 status = RESULT_OK;
    
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
	{
        	return RESULT_FAIL;
    }
	else
    {
      	app = (APP_SYSINFO_T*)APP_InitAppData( 
														(void *)APP_HandleEventPrepost,
                                                  		sizeof(APP_SYSINFO_T),
                                                  		reg_id,
                                                  		0, 1,
                                                  		1,
                                                  		2, 0, 0 
		);
                                                  
    
        
		status = APP_Start( 
							ev_st,
                            &app->apt,
                            HW_STATE_MAIN,
                            state_handling_table,
                            SysInfoExit,
                            app_name,
                            0 
		);

    }

    return RESULT_OK;

}



UINT32 SysInfoExit( EVENT_STACK_T *ev_st,  void *app ){
    
	UINT32  status;

    status = APP_Exit( ev_st, app, NULL );

   	LdrUnloadELF(&Lib);
	
    return status;
}


UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type ){
    
    return RESULT_OK;

}

UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);

    UtilLogStringData(" *** ELF *** PDSBackup: key pressed 0x%X", event->data.key_pressed);

	
    
    if(event->data.key_pressed == KEY_STAR)
	{
		if(bPressStar == TRUE)
		{ 
		
			UtilLogStringData(" *** ELF *** PDSBackup: key pressed star double");
			BackupToFil();
			
		}
		else
			UtilLogStringData(" *** ELF *** PDSBackup: key pressed star once");
	}
	else
	{
		if(bPressStar == TRUE && event->data.key_pressed == KEY_POUND)
		{ 
			DL_AudPlayTone(event->data.key_pressed, 2);
			UtilLogStringData(" *** ELF *** PDSBackup: key pressed star and pound");
			return SysInfoExit(ev_st, app);
		}
		else
			UtilLogStringData(" *** ELF *** PDSBackup: key pressed other");
	}
    
    return RESULT_OK;
}

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);

    if(event->data.key_pressed == KEY_STAR)
	{
		if(bPressStar == FALSE)
			bPressStar = TRUE;
	}
	else
		bPressStar = FALSE;
    return RESULT_OK;
}


UINT32 BackupToFil()
{
       
        
      
       UINT8 h,m,h2,m2;
       //UINT32 m1,h1;
       UINT8 ccc[3];
        
        UINT8* p2; 
      
        p2=&ccc[0];
      
        DL_ClkGetTime(p2);
       
        h=ccc[0];
        m=ccc[1];
        
        // h1=(h/10)*10;
         h2=h%10;
        
       // m1=(m/10)*10;
        m2=m%10;
        
       
       hour(h,h2);
        
       
        Jiu1();
       
               
     miao(m,m2);
       
   
     
      Jiu2();
   return RESULT_OK;
}   

UINT32  Jiu( UINT8 i)
{   WCHAR* strFilePath = suAllocMem( 100, NULL );

    switch(i)
  {
     case 0:
         u_atou( "file://b/soundbaoshi/SOUND/0.AMR", strFilePath); 
         break; 
      case 1:
         u_atou( "file://b/soundbaoshi/SOUND/1.AMR", strFilePath); 
         break; 
      case 2:
         u_atou( "file://b/soundbaoshi/SOUND/2.AMR", strFilePath); 
         break; 
       case 3:
         u_atou( "file://b/soundbaoshi/SOUND/3.AMR", strFilePath); 
         break; 
    case 4:
         u_atou( "file://b/soundbaoshi/SOUND/4.AMR", strFilePath); 
         break; 
    case 5:
         u_atou( "file://b/soundbaoshi/SOUND/5.AMR", strFilePath); 
         break; 
    case 6:
         u_atou( "file://b/soundbaoshi/SOUND/6.AMR", strFilePath); 
         break; 
    case 7:
        u_atou( "file://b/soundbaoshi/SOUND/7.AMR", strFilePath); 
         break; 
    case 8:
         u_atou( "file://b/soundbaoshi/SOUND/8.AMR", strFilePath); 
         break; 
    case 9:
        u_atou( "file://b/soundbaoshi/SOUND/9.AMR", strFilePath); 
         break; 
    case 10:
        u_atou( "file://b/soundbaoshi/SOUND/10.AMR", strFilePath); 
         break;
   case 11:
        u_atou( "file://b/soundbaoshi/SOUND/11.AMR", strFilePath); 
         break; 
 case 12:
        u_atou( "file://b/soundbaoshi/SOUND/12.AMR", strFilePath); 
         break; 
 case 13:
        u_atou( "file://b/soundbaoshi/SOUND/13.AMR", strFilePath); 
         break; 
 case 14:
        u_atou( "file://b/soundbaoshi/SOUND/14.AMR", strFilePath); 
         break; 
 case 15:
        u_atou( "file://b/soundbaoshi/SOUND/15.AMR", strFilePath); 
         break; 
 case 16:
        u_atou( "file://b/soundbaoshi/SOUND/16.AMR", strFilePath); 
         break; 
 case 17:
        u_atou( "file://b/soundbaoshi/SOUND/17.AMR", strFilePath); 
         break; 
 case 18:
        u_atou( "file://b/soundbaoshi/SOUND/18.AMR", strFilePath); 
         break; 
 case 19:
        u_atou( "file://b/soundbaoshi/SOUND/19.AMR", strFilePath); 
         break; 
 case 20:
        u_atou( "file://b/soundbaoshi/SOUND/20.AMR", strFilePath); 
         break; 
   
    }
         
   
     MME_GC_playback_open_audio_play_forget(strFilePath);
        
      
       suFreeMem( strFilePath);
   return RESULT_OK;
 
}
UINT32  Jiu1(){
	 
	 WCHAR* strFilePathaud = suAllocMem( 80, NULL );
	u_atou( "file://b/soundbaoshi/SOUND/D.AMR", strFilePathaud); 
        
      
      MME_GC_playback_open_audio_play_forget(strFilePathaud);
        
      
       suFreeMem( strFilePathaud);
       return RESULT_OK;
}
UINT32  Jiu2(){
	 
	 WCHAR* strFilePathauf = suAllocMem( 80, NULL );
	u_atou( "file://b/soundbaoshi/SOUND/F.AMR", strFilePathauf); 
        
      
      MME_GC_playback_open_audio_play_forget(strFilePathauf);
        
      
       suFreeMem( strFilePathauf);
       return RESULT_OK;
}

UINT32  miao( UINT8 miao1,UINT8 miao2){
	
	 WCHAR* strFilePathau1 = suAllocMem( 80, NULL );
	if(miao1<=20)
       {  
          Jiu(miao1);
        }
        else if(miao1>20 && miao1<30)
       {  
          u_atou( "file://b/soundbaoshi/SOUND/20.AMR", strFilePathau1); 
          MME_GC_playback_open_audio_play_forget(strFilePathau1);
          suFreeMem( strFilePathau1);        
          Jiu(miao2);
       
        } 
     
       else if(miao1>=30 && miao1<40)
       {  
          u_atou( "file://b/soundbaoshi/SOUND/30.AMR", strFilePathau1); 
          MME_GC_playback_open_audio_play_forget(strFilePathau1);
          suFreeMem( strFilePathau1);        
          Jiu(miao2);
       
        } 
       else if(miao1>=40 && miao1<50)
       {  
           u_atou( "file://b/soundbaoshi/SOUND/40.AMR", strFilePathau1); 
           MME_GC_playback_open_audio_play_forget(strFilePathau1);
           suFreeMem( strFilePathau1);        
           Jiu(miao2);
       
        }  
        else if(miao1>=50 && miao2<60)
       {  
          u_atou( "file://b/soundbaoshi/SOUND/50.AMR", strFilePathau1); 
          MME_GC_playback_open_audio_play_forget(strFilePathau1);
          suFreeMem( strFilePathau1);        
          Jiu(miao2);
       
        } 
	
	return RESULT_OK;
}
UINT32  hour( UINT8 hour1,UINT8 hour2){
	WCHAR* strFilePathau = suAllocMem( 80, NULL );
 if(hour1<=20)
       {  
        Jiu(hour1);
    
        }
        else if(hour1>20)
      {
        	
       u_atou( "file://b/soundbaoshi/SOUND/20.AMR", strFilePathau); 
       MME_GC_playback_open_audio_play_forget(strFilePathau);
       suFreeMem( strFilePathau);        
       Jiu(hour2);		
             
        }     
     	return RESULT_OK;
}   