
#ifndef UIS_H
#define UIS_H

#include <apps.h>
#include <typedefs.h>
#include <stdarg.h>
#include <resources.h>

enum
{
    ACTION_OP_ADD = 0,
    ACTION_OP_DELETE,
    ACTION_OP_UPDATE
};

typedef struct
{
    UINT8             operation;        //      (ACTION_OP_*)
    EVENT_CODE_T      event;            // ,      
    RESOURCE_ID       action_res;       // ,   (. RES_ACTION_LIST_ITEM_T)

} ACTION_ENTRY_T;

typedef struct
{
    UINT8             count;            // - 
    ACTION_ENTRY_T    action[16];       //       

} ACTIONS_T;

typedef struct
{
    char             format[40];
    UINT32            count;
    UINT32            data[40];
} CONTENT_T;


      /*   */
      
      
/*   */
UINT32 UIS_MakeContentFromString( char *format,  CONTENT_T *dst,  ... );
/* / * More information about the string format: 
     The line consists of pointers to incoming parameters 
     specifiers and alignment. 
     Pointers are the type and number of function parameters, 
     possible types: 
     q - a pointer to a string WCHAR 
     s - resource line 
     i - int 
     g - hex int 
     p - resource picture 
     r - CONTENT_T 
     f - pointer to the file 
     Specificators alignment: 
     N - new line 
     S - distribution of text 
     C - text in the center 
     L - "...", trimmed with a string is too long 
     M - the middle of the text (vertical alignment) 
     T - text on top 
     B - text from the bottom 
     
     For example: "MCq0p1" = "Bring the middle and at the center first 
     dst option after a string, and the second - as a picture "* / */

/*   EV_GRANT_TOKEN */
UINT32 APP_HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );

/*   EV_REVOKE_TOKEN */
UINT32 APP_HandleUITokenRevoked( EVENT_STACK_T *ev_st,  void *app );

/*  ,  APP_UtilChangeState,      (consumed) event */
UINT32 APP_UtilConsumeEvChangeState( UINT8 new_state,  EVENT_STACK_T *ev_st,  void *app );

/*    */
UINT32 UIS_HandleEvent( UIS_DIALOG_T dialog,  EVENT_STACK_T *ev_st );

/*    UI */
UINT32 UIS_Refresh( void );

/*       NULL */
UINT32 APP_UtilUISDialogDelete( UIS_DIALOG_T  *pdialog );

///UIS_SetActionList


      /*    */

enum
{
    NOTICE_TYPE_DEFAULT = 0,
    NOTICE_TYPE_OK,
    NOTICE_TYPE_FAIL,
    NOTICE_TYPE_WAIT
  /*     ,  
      -       SDK */
};

/*    . type = NOTICE_TYPE_* */
UIS_DIALOG_T UIS_CreateTransientNotice( SU_PORT_T *port,  CONTENT_T *content,  UINT8 type );

/*  - */
UIS_DIALOG_T UIS_CreateConfirmation( SU_PORT_T *port,  CONTENT_T *content );
  

/*  - */
UIS_DIALOG_T UIS_CreateList( SU_PORT_T       *port,
                             UINT32          param1,          // = 0  ID?
                             UINT32          count,           //    
                             UINT32          marks,           // -   
                             UINT32          *starting_num,   //      
                             UINT8           param5,          // = 0
                             UINT8           param6,          // = 2
                             ACTIONS_T       *actions,        //  
                             RESOURCE_ID     caption );       //  


typedef struct
{
    UINT16	            type;
    RESOURCE_ID	        label;
    BOOL	              readonly;
    BOOL	              show;
    BOOL	              unk5;
    UINT32	            maxlen;
    RESOURCE_ID	        resource;
    UINT32	            unk8;
} FIELD_DESCR_T;

typedef struct
{
    RESOURCE_ID       descr_res;    //   FIELD_DESCR_T
    UINT32            data;         //   (RESOURCE_ID/WCHAR*/CONTENT_T*/UINT32)
    BOOL              unk3;     
    BOOL              unk4;
    BOOL              unk5;         // = 0
} FIELD_T; 


typedef struct
{
    CONTENT_T           text;
    UINT32              unk1;
    RESOURCE_ID         marks[2];
    RESOURCE_ID         unk3[2];
    RESOURCE_ID         unk4[2];
    UINT8               unk5;
    UINT8               unk6; // = 1
} STATIC_LIST_ENTRY_T;  

typedef union
{
    STATIC_LIST_ENTRY_T     static_entry;     // ,  editable == FALSE
    FIELD_T                 editable_entry;   // ,  editable == TRUE
    UINT8                   pad[0xEC];
} LIST_CONTENT_T;


typedef struct
{
    BOOL                    editable;   //    
    UINT32                  unk1;       // ??
    LIST_CONTENT_T          content;
    
    UINT8                   pad[0xF8-0xEC-0x8];
} LIST_ENTRY_T;


/*   - */
UIS_DIALOG_T UIS_CreateStaticList( SU_PORT_T  *port,
                                   UINT32          param1,          // = 0 ID?
                                   UINT32          count,
                                   UINT32          marks,
                                   LIST_ENTRY_T    *entries, 
                                   UINT8           param5,          // = 0
                                   UINT8           param6,          // = 2
                                   ACTIONS_T       *actions,
                                   RESOURCE_ID     caption );
                                    

UIS_DIALOG_T UIS_CreateCharacterEditor( SU_PORT_T  *port,
                                        WCHAR           *text,
                                        UINT8           edit_type,
                                        UINT32          maxlen,
                                        BOOL            masked, //?
                                        ACTIONS_T       *actions, 
                                        RESOURCE_ID     dlgres ); 
/* 
   edit_type:
0 -     
1 -  
2 -  .   
3 - ,    
4 -  
5 -    
6 -     
7 -     
8 - ,  
9 -  4,   
10 - ,  
11 -  0,     
12 -  1,     
23 - url
28 -   
29 - ,    
32 -  
*/
										
										
										
//     UIS_CreateCharacterEditor										
UINT32 AFW_TranslateEvEvD(EVENT_STACK_T    *ev_st,
                          UINT16           event_code,
                          ADD_EVENT_DATA_T *data );										
                        
UIS_DIALOG_T UIS_CreateViewer( SU_PORT_T  *port,
                               CONTENT_T       *contents,
                               ACTIONS_T       *actions );
                        
UIS_DIALOG_T UIS_CreatePictureAndTextList( SU_PORT_T  *port,
                                           UINT32          param1,
                                           UINT32          count, 
                                           UINT32          *starting_num, 
                                           UINT8           param4, // = 2
                                           UINT8           param5, // = 0
                                           UINT8           param6, // = 1, try 0,2,...
                                           ACTIONS_T       *actions, 
                                           RESOURCE_ID     dlgres );


#endif