#ifndef MME_H
#define MME_H


#define EV_MME_OPEN_SUCCESS       0xC1000 //   
#define EV_MME_OPEN_ERROR         0xC1001 //    
#define EV_MME_SEEK               0xC1002 //    - MME_GC_playback_seek
#define EV_MME_PLAY_COMPLETE      0xC100D //    

/*******************************/

typedef enum
{
	// 
	MMSS_MIME_TYPE_IMAGE_BEGIN = 0,
	MMSS_MIME_TYPE_IMAGE_GIF = MMSS_MIME_TYPE_IMAGE_BEGIN,
	MMSS_MIME_TYPE_IMAGE_BMP,
	MMSS_MIME_TYPE_IMAGE_WBMP,
	MMSS_MIME_TYPE_IMAGE_PNG,
	MMSS_MIME_TYPE_IMAGE_JPEG,
	MMSS_MIME_TYPE_IMAGE_EMS_USERDEFINED_PICTURE,
	MMSS_MIME_TYPE_IMAGE_EMS_USERDEFINED_ANIMATION,
	MMSS_MIME_TYPE_IMAGE_EMS_PREDEFINED_ANIMATION,
	MMSS_MIME_TYPE_IMAGE_SLIDESHOW,
	MMSS_MIME_TYPE_IMAGE_EMSBMP,
	MMSS_MIME_TYPE_IMAGE_SIS,
	MMSS_MIME_TYPE_IMAGE_END,

	//  
	MMSS_MIME_TYPE_AUDIO_BEGIN = MMSS_MIME_TYPE_IMAGE_END,
	MMSS_MIME_TYPE_AUDIO_MID = MMSS_MIME_TYPE_AUDIO_BEGIN,
	MMSS_MIME_TYPE_AUDIO_MIDI,
	MMSS_MIME_TYPE_AUDIO_MIX,
	MMSS_MIME_TYPE_AUDIO_BAS,
	MMSS_MIME_TYPE_AUDIO_MP3,
	MMSS_MIME_TYPE_AUDIO_AAC,
	MMSS_MIME_TYPE_AUDIO_AU,
	MMSS_MIME_TYPE_AUDIO_AIFF,
	MMSS_MIME_TYPE_AUDIO_PCM,
	MMSS_MIME_TYPE_AUDIO_ADPCM,
	MMSS_MIME_TYPE_AUDIO_WAV,
	MMSS_MIME_TYPE_AUDIO_WMA,
	MMSS_MIME_TYPE_AUDIO_PLAYLIST,
	MMSS_MIME_TYPE_AUDIO_AMR,
	MMSS_MIME_TYPE_AUDIO_AMRWB,
	MMSS_MIME_TYPE_AUDIO_MP4,
	MMSS_MIME_TYPE_AUDIO_M4A,
	MMSS_MIME_TYPE_AUDIO_GSM610,
	MMSS_MIME_TYPE_AUDIO_JSR135_TONESEQ,
	MMSS_MIME_TYPE_AUDIO_REAL,
	MMSS_MIME_TYPE_AUDIO_MMA,
	MMSS_MIME_TYPE_AUDIO_QCELP,
	MMSS_MIME_TYPE_AUDIO_XMF,
	MMSS_MIME_TYPE_AUDIO_END,

	// 
	MMSS_MIME_TYPE_VIDEO_BEGIN = MMSS_MIME_TYPE_AUDIO_END,
	MMSS_MIME_TYPE_VIDEO_ASF = MMSS_MIME_TYPE_VIDEO_BEGIN,
	MMSS_MIME_TYPE_VIDEO_WMV,
	MMSS_MIME_TYPE_VIDEO_MP4,
	MMSS_MIME_TYPE_VIDEO_MPEG4,
	MMSS_MIME_TYPE_VIDEO_H263,
	MMSS_MIME_TYPE_VIDEO_SDP,
	MMSS_MIME_TYPE_VIDEO_RAW,
	MMSS_MIME_TYPE_VIDEO_TST,
	MMSS_MIME_TYPE_VIDEO_RTSP,
	MMSS_MIME_TYPE_VIDEO_RAM,
	MMSS_MIME_TYPE_VIDEO_REAL,
	MMSS_MIME_TYPE_VIDEO_NOA,
	MMSS_MIME_TYPE_VIDEO_NOW,
	MMSS_MIME_TYPE_VIDEO_3G2,
	MMSS_MIME_TYPE_VIDEO_SVG,
	MMSS_MIME_TYPE_VIDEO_MMV,
	MMSS_MIME_TYPE_VIDEO_END,

	// 
	MMSS_MIME_TYPE_RINGER_BEGIN = MMSS_MIME_TYPE_VIDEO_END,
	MMSS_MIME_TYPE_RINGER_IMELODY = MMSS_MIME_TYPE_RINGER_BEGIN,
	MMSS_MIME_TYPE_RINGER_MOTOROLA_TONE,
	MMSS_MIME_TYPE_RINGER_MYMIX,
	MMSS_MIME_TYPE_RINGER_MMT,
	MMSS_MIME_TYPE_RINGER_END,

	MMSS_MIME_TYPE_END = MMSS_MIME_TYPE_RINGER_END,
	MMSS_MIME_TYPE_INVALID
}MMSS_MIME_TYPE_T;




//  //
typedef   void*    MME_GC_MEDIA_FILE;

//   uri  ,      
MME_GC_MEDIA_FILE  MME_GC_playback_create(SU_PORT_T * port, WCHAR * uri, UINT32 unk1, UINT32 unk2, UINT32 unk3, UINT32 unk4, UINT32 unk5, UINT32 unk6); 

//  
UINT32 MME_GC_playback_delete(MME_GC_MEDIA_FILE  media_file); 

//   
UINT32 MME_GC_playback_start(MME_GC_MEDIA_FILE  media_file, UINT32 unk1, UINT32 unk2); 

//   
UINT32 MME_GC_playback_stop(MME_GC_MEDIA_FILE  media_file); 

// 
UINT32 MME_GC_playback_pause(MME_GC_MEDIA_FILE  media_file); 

//   ms .   
UINT32 MME_GC_playback_seek(MME_GC_MEDIA_FILE  media_file, UINT32 ms); 

//   
typedef enum
{
	DURATION=1,   
	DURATION_MS,
	POSITION=73,   
	POSITION_MS
}ATTRIBUTE_NAME;

UINT32 MME_GC_playback_get_attribute( MME_GC_MEDIA_FILE     handle,
									  ATTRIBUTE_NAME   		attribute_name,
								      void  				*attribute_value
									);



#endif
