
#ifndef EVENTS_H
#define EVENTS_H

#include <typedefs.h>

// . EVENT_T ?EVENT_DATA_T @apps.h

#define EV_GRANT_TOKEN            30
#define EV_REVOKE_TOKEN           31

#define EV_KEY_PRESS              500 	// key_pressed
#define EV_KEY_RELEASE            501 	// key_pressed

// ??  ?
#define EV_DIALOG_DONE            0x201C
// ???  "?
#define EV_DONE                   0x2020
// ????? ?
#define EV_LIST_NAVIGATE          0x2043 // index
// ????? ? "?
#define EV_SELECT                 0x2058 // EVENT_DATA_T.index
// ?  ??? 
#define EV_REQUEST_LIST_ITEMS     0x202C // list_items_req
// ? ?
#define EV_NO                     0x2046
#define EV_YES                    0x2079
#define EV_CANCEL	          0x2008


//  
#define EV_DATA                   0x200F // EVENT_T::attachment
// ?
#define EV_BROWSE                 0x2006

// ????- ?
#define EV_DATA_CHANGE            0x2011 // index
// ?
#define EV_REQUEST_DATA           0x202B // data_req

//  
#define EV_TIMER_EXPIRED		  0x8205A // (DL_TIMER_DATA_T*)EVENT_T::attachment

#define EV_MME_OPEN_SUCCESS       0xC1000 // successfull file opening
#define EV_MME_OPEN_ERROR         0xC1001 // not successfull file opening 
#define EV_MME_SEEK               0xC1002 // occurs after use of the fMME_GC_playback_seek 
#define EV_MME_PLAY_COMPLETE      0xC100D // arose at the end of play

#define EV_IN_PHOTO          1019
#define EV_SMS_INBOX         1329
#define EV_CALL_INBOX        0x790
#define EV_BLOCK_KEYBOARD    1707
#define EV_UNBLOCK_KEYBOARD  1694
#define EV_SHOW_MYNUMBER      1931
#define EV_OPEN_MENU         8377
#define EV_OPEN_GAMEAPP      0x03d6
#define EV_PlayFunLight      0x0cc7
#define EV_PauseFunLight 0CC6

#define EV_INCALLING  0x0670
#define EV_INSMSING   0x04E3
#define EV_ALMCLK_REMINDER 0xD69

//extern const UINT16 *ALMCLK_REMINDER_START;
//UINT32 event= *ALMCLK_REMINDER_START;
//extern const UINT32 *CALL_ALERT; 
//UINT32 event = *CALL_ALERT;

typedef enum
{
      FBF_FREE = 100,  //    
      FBF_LEAVE        //   ? ??
} FREE_BUF_FLAG_T;

typedef struct
{
    UINT32                    bufsize;
    UINT32                    index;
    UINT8                     unk2;
} REQUEST_DATA_T;

typedef struct
{
    UINT32                    ID;           // ? ?
    UINT32                    begin_idx;    // ?   ?
    UINT8                     count;        // ?? 
} REQUEST_LIST_ITEMS_T;

/* ? ?  ,  ? */
typedef union
{
    UINT8                           key_pressed;
    UINT32                          index;
    REQUEST_LIST_ITEMS_T            list_items_req;
    REQUEST_DATA_T                  data_req;

    //ELF parameters
    ELF_PARAMS_T                    start_params;
    //padding to real size
    UINT8                           pad[0xFC];               
} EVENT_DATA_T;

typedef struct
{
    UINT32                    data_tag;
    EVENT_DATA_T              data;
} ADD_EVENT_DATA_T;

/* ??  */
typedef struct tagEVENT_T
{
    EVENT_CODE_T              code;
    UINT32                    unk1;
    UINT32                    ev_port;
    UINT8                     unk2;
    BOOL                      is_consumed;
    BOOL                      is_firstpass;
    UINT8                     unk3;
    UINT32                    unk4;
    UINT32                    unk5;
    struct tagEVENT_T        *next;
    UINT32                    data_tag;
    EVENT_DATA_T              data;
    BOOL                      is_attach;
    UINT16                    att_size;
    void                      *attachment;
    UINT8                     unk6;
} EVENT_T; //size = 296


typedef struct
{
    EVENT_CODE_T              code;
    UINT8                     unk1;
    UINT8                     unk2;
    EVENT_T                   *top;
    void                      *unk3;
    UINT8                     unk4[6];
    UINT8                     unk5;
} EVENT_STACK_T;

//  ?event  
EVENT_T* AFW_GetEv( EVENT_STACK_T *ev_st );

// ??  (????  )
UINT32 AFW_AddEvNoD( EVENT_STACK_T    *ev_st,  
                     UINT16           event_code );

UINT32 AFW_AddEvEvD( EVENT_STACK_T    *ev_st,
                     UINT16           event_code,
                     ADD_EVENT_DATA_T *data );

UINT32 AFW_AddEvAux( EVENT_STACK_T    *ev_st,
                     UINT16           event_code,
                     FREE_BUF_FLAG_T  free_buf,
                     UINT32           att_size,
                     void             *attachment );

UINT32 AFW_AddEvAuxD( EVENT_STACK_T     *ev_st,
                      UINT16            event_code,
                      ADD_EVENT_DATA_T  *data,
                      FREE_BUF_FLAG_T  free_buf,
                      UINT32           att_size,
                      void             *attachment );

//  ?? 
UINT32 APP_ConsumeEv( EVENT_STACK_T *ev_st,  void *app );


//  ?EV_LIST_ITEMS (? EV_REQUEST_LIST_ITEMS)
UINT32 APP_UtilAddEvUISListData( EVENT_STACK_T    *ev_st,
                                 void             *app,
                                 UINT32           param2, // = 0
                                 UINT32           begin_index,
                                 UINT8            count,
                                 FREE_BUF_FLAG_T  free_buf,
                                 UINT32           bufsize,
                                 void             *buffer );

//  ?EV_REQUEST_DATA  ? ? 
UINT32 APP_UtilAddEvUISGetDataForItem( EVENT_STACK_T    *ev_st,
                                       void             *app,
                                       UINT32           index ); 

UINT32 APP_UtilAddEvUISListChange( EVENT_STACK_T    *ev_st,
                                   void             *app,
                                   UINT32           param2, // = 0
                                   UINT32           pos,
                                   UINT8            size,
                                   BOOL             refresh_data,
                                   UINT8            param6,          // = 2
                                   FREE_BUF_FLAG_T  free_buf,
                                   UINT32           bufsize,
                                   void             *buffer );									   


#endif
