
#ifndef SDK_DL_H
#define SDK_DL_H

#include <typedefs.h>

#define KEY_0       0
#define KEY_1       1
#define KEY_2       2
#define KEY_3       3
#define KEY_4       4
#define KEY_5       5
#define KEY_6       6
#define KEY_7       7
#define KEY_8       8
#define KEY_9       9
#define KEY_STAR    10
#define KEY_POUND   11

#define KEY_RED     17
#define KEY_GREEN   18

#define KEY_MENU    20
#define KEY_SMART   21

#define KEY_VOLUP   23
#define KEY_VOLDOWN 24

#define KEY_UP      44
#define KEY_DOWN    45
#define KEY_LEFT    46
#define KEY_RIGHT   47

#define KEY_CAM     0x3F

UINT32 DL_AudPlayTone( UINT32 tone,  UINT8 volume ); //Current volume = 0xFF

				/* ??-  ?*/

/* ? ?  ??EV_TIMER_EXPIRED, attachment  ? DL_TIMER_DATA_T */

typedef struct
{
	UINT32		time;
	UINT32		ID;
} DL_TIMER_DATA_T;

/*  ?, ???time  */
UINT32 APP_UtilStartTimer( UINT32 time,  UINT32 ID,  void *app ); // ID ??DL_TIMER_DATA_T ??

/*  ?, ?? ? time  */
UINT32 APP_UtilStartCyclicalTimer( UINT32 time,  UINT32 ID,  void *app );

/*   */
UINT32 APP_UtilStopTimer( void *app );

///////////////////// Added by om2804 //////////////////////

/* ?  

	E398 ONLY! */
void HAPI_LP393X_disp_backlight_intensity( UINT32 light ); // light = 0..100

/* ? ??
	type: 0-? 1-?
	val: 0xRGB (0x000 - 0xFFF),  0x00E - ?

	E398 ONLY! */
void HAPI_LP393X_set_tri_color_led( UINT32 type,  UINT32 val );

/////////////////// Added by WhiteHotIce /////////////////////

/*   */
void HAPI_WATCHDOG_soft_reset( void );

/*  ? */
void pu_main_powerdown(UINT32 r0);

///////////////////// Added by G-XaD ///////////////////////

/*  ??seem_data count   seem,  record
	???  ?count  ?! */
UINT32 SEEM_FDI_OUTSIDE_SEEM_ACCESS_read( UINT32 seem,  UINT32 record,  void* seem_data,  UINT32 count );

/*    seem_data count  ??seem,  record
	 ?*/
#define SEEM_WRITE_METHOD_ADD				0
#define SEEM_WRITE_METHOD_UPDATE			1
UINT32 SEEM_FDI_OUTSIDE_SEEM_ACCESS_write( UINT32 method,  UINT32 seem,  UINT32 record,  void* seem_data,  UINT32 count );
/* ?? format   (? ??MidWay)
	  ?  */
void PFprintf( char* format, ... ); // %d %x %s, a-la printf


/*  ?funlight) ??fl_id
	 ?  ???? ?p2 = 3,
	    ? ?? ( ?...) 

	 E398 ONLY! */
UINT32 DL_AudStartFunlight( UINT8 fl_id,  UINT32 p2,  UINT32 p3 ); // p2 = 1, p3 = 0

/* ??funlight) ??fl_id 

	E398 ONLY! */
UINT32 DL_AudStopFunlight( UINT8 fl_id );

/* ? */
void DAL_DisableDisplay( UINT32 p1 ); // p1 = 0

/*   */
void DAL_EnableDisplay( UINT32 p1 ); // p1 = 0
  typedef struct
{
    UINT8     day;
    UINT8     month;
    UINT16    year;
} CLK_DATE_T;

UINT32 DL_ClkGetDate(CLK_DATE_T*);

UINT32 DL_ClkGetTime(UINT8* time);

UINT32 MME_GC_playback_open_audio_play_forget(WCHAR* filename );

void DL_KeyInjectKeyPress(UINT8 p1,UINT8 p2,UINT8 p3);

BOOL DL_DbFeatureGetCurrentState( UINT16 fstate_ID, UINT8 *result );

UINT32 DL_DbFeatureStoreState(UINT16 fstate_ID, UINT8 state);
// fstate_IDoffset in the base  
// state written value

typedef struct
{
    WCHAR            *url;           
    UINT32           unk;    
} UIS_SETWALLPAPER_SETTINGS_T;

UINT32 UIS_SetWallpaper(UIS_SETWALLPAPER_SETTINGS_T * );


UINT32 DL_AudSetVolumeSetting(UINT8 volume_type,UINT8 volume);

UINT32 DL_AudGetVolumeSetting(UINT8 volume_type,UINT8 *volume);

UINT32 DL_SigRegQuerySignalStrength(UINT32 * Strength);

UINT32 DL_ClkGetClock(UINT32 * clock);

UINT32 DL_DbFeatureStoreBlock(UINT32 MN,UINT16 *ID,UINT32 P3); 

UINT32 DL_FsGetIDFromURI(WCHAR* url,UINT16 *ID);

UINT8 HAPI_ATOD_convert_ambient_light_sensor( void );

////////////////////

#define AUDIO_STATUS 	0x69
#define GPRS_STATUS		0x1D
#define Network_STATUS  0x27

#define SetClock_STATUS  0x38
#define SetCallGuard_STATUS 0x42

//IdleHandleNetworkStatus

typedef UINT8 STATUS_ID;

typedef union
{
    INT32                            integer;
    BOOL                             boolean;
    WCHAR                            *currency;
    WCHAR                            *quoted_name;
    WCHAR                            *quoted_phone_number;
    WCHAR                            *quoted_string;
    UINT32                      	 phone_type;
} STATUS;

UINT32 UIS_SetStatus(STATUS_ID status_id, STATUS value);
////////////////////////////////


/////////////////////////////////

#define MAX_CALLS                   7

typedef UINT8 CALL_OVERALL;
typedef UINT8 CALL_STATE;
typedef UINT16  CALL_ID;

typedef struct
{       
    CALL_ID                call_id;  
   CALL_STATE             call_state;
} CALL_ID_;

typedef struct
{
    UINT8  number_of_calls;
    CALL_OVERALL overall_call_state;
    CALL_ID_ call_state_info[MAX_CALLS];
} CALL_STATES;


// number_of_calls == 0, 

void DL_SigCallGetCallStates(CALL_STATES *call_states);



///////////////////////////////

BOOL APP_MMC_Util_IsVoiceCall(void); 

/* Get the system time in the teak */ 

UINT64 suPalReadTime (void); 
/*Translate time of the ticks in milliseconds*/ 

UINT64 suPalTicksToMsec (UINT64 ticks);

UINT8 DRM_GetCurrentLanguage(UINT8 *);

#define DialogType_Homescreen 0xe
#define DialogType_Menu 0x2d
#define DialogType_list 0x10
#define DialogType_Phonebook 0x28
//#define DialogType_
UINT32 UIS_GetActiveDialogType(UINT8* res);

UINT8 DL_DbFeatureGetValueString(UINT32 feature_id, WCHAR *feature_string );

#endif