#ifndef MISC_H
#define MISC_H

#include <events.h>
#include <typedefs.h>

//       offset  ptr.  " ".
#define _mget(ptr, offset) ((ptr) + (offset))

//      ptr   bit
#define _bit(ptr, bit) (((*(char*)((ptr) + ((bit) / 8))) >> (7 - ((bit) % 8))) & 1)

//   
#define sign(num) (((num) == 0) ? 0 : (((num) > 0) ? 1 : -1))

typedef struct _uMemData {
	struct	_uMemData	*prev, *next;
	size_t				size;
} uMemData;

#ifdef __cplusplus
extern "C" {
#endif

//    Unicode <=> ANSI.   "u.c"
char*	a_wtoa(const WCHAR *ustr, char *astr, int n);
WCHAR*	w_atow(const char *astr, WCHAR *ustr, int n);

//    Unicode => WIN1251  UTF8 => WIN1251.   "charset_conf.c"    
char*	a_wtoCP1251(const WCHAR *ustr, char *astr, int n);
char*	a_UTF8toCP1251(const char *fstr, char *astr, int n);

//    n      p
char*	a_strndel(char *astr, int p, int n);
WCHAR*	w_strndel(WCHAR *ustr, int p, int n);

//     junk  
char*	a_ltrim(char *astr, char junk);		// 
WCHAR*	w_ltrim(WCHAR *ustr, WCHAR junk);
char*	a_rtrim(char *astr, char junk);		// 
WCHAR*	w_rtrim(WCHAR *ustr, WCHAR junk);
char*	a_trim(char *astr, char junk);		//   
WCHAR*	w_trim(WCHAR *ust, WCHAR junkr);

//      junk  
int		a_chrcnt(char *astr, char junk);
int		w_chrcnt(WCHAR *ustr, WCHAR junk);

//      
char*	a_replace(char *astr, char find, char repl);
WCHAR*	w_replace(WCHAR *ustr, WCHAR find, WCHAR repl);

//    
WCHAR*	w_mkdir(WCHAR *dst, const WCHAR *uri);
WCHAR*	w_mkpath(WCHAR *dst, const WCHAR *dir, const WCHAR *str, BOOL fsprefix);

//    
void*	w_fsread(const WCHAR *fn, UINT32 len, UINT32 *readen);
void*	a_fsread(const char *fn, UINT32 len, UINT32 *readen);

//    
void*	w_fswrite(const WCHAR *fn, char *buf, UINT32 len, UINT32 *written);
void*	a_fswrite(const char *fn, char *buf, UINT32 len, UINT32 *written);

//    .   "func.c"
UINT32	timerInit(UINT32 period, UINT32 id, BOOL cyclical, void *app);
UINT32	timerDel(UINT32 *handle, void *app);

//    
UINT32	t_timerinit(void);
UINT32	t_timerdiff(UINT32 timer, UINT32 now);

//   "' :"
inline	void	a_time2dhm(UINT32 time, char *buf);
//   ":"
inline	void	a_time2hm(UINT32 time, char *buf);
//   "::"
inline	void	a_time2hms(UINT32 time, char *buf);
//   "::."
inline	void	a_time2hmsms(UINT32 time, char *buf);

//     
inline	UINT32	hms2time(UINT8 h, UINT8 m, UINT8 s);

//    ( )
inline	UINT32	now(void);

//  /      
inline	void*	_alloc(size_t size);	//  
inline	void	_free(void *ptr);		//  
inline	UINT32	_leak(void);			//     
inline	UINT32	_bleak(void);			//     
void			_cleanup(BOOL force);	//    .  force,     .

#ifdef __cplusplus
}
#endif

#endif /* MISC_H */
