////////////////////////////////////////////////////////////////////////////////
//  

#include <filesystem.h>
#include <utilities.h>
#include <time_date.h>
//#include <loader2.h>
#include <apps.h>
#include <mem.h>

#include "misc.h"
#include "bmp.h"





////////////////////////////////////////////////////////////////////////////////
//   /
static	const WCHAR	fs_prefix[] = {'f','i','l','e',':','/',0};

static	UINT32		mem_allocated = 0, mem_blocks = 0;
static	uMemData	*mem_first = NULL, *mem_last = NULL;





char*	a_wtoa(const WCHAR *ustr, char *astr, int n) {
	int	i = 0;

	while (i < n && ustr[i]) {
		astr[i] = (char)ustr[i];
		i++;
	}
	astr[i] = 0;

	return astr;
}

WCHAR*	w_atow(const char *astr, WCHAR *ustr, int n) {
	int	i = 0;

	while (i < n && astr[i]) {
		ustr[i] = (WCHAR)astr[i];
		i++;
	}
	ustr[i] = 0;

	return ustr;
}

char*	a_wtoCP1251(const WCHAR *ustr, char *astr, int n) {
	int		i = 0;
	char	*tmp = astr;

	while (i < n && *ustr) {
		if (*ustr < 0xA0) { *tmp = *ustr; }
		else if ( *ustr == 0x0451 ) { *tmp = 0xB8; }	// 
		else if ( *ustr == 0x0401 ) { *tmp = 0xA8; }	// 
		else if ( *ustr > 0x040F ) { *tmp = *ustr - 0x0350; }	// cyr
		else { *tmp = 0x3F; }	// ?
		ustr++;
		tmp++;
		i++;
	}

	*tmp = 0;

	return astr;
}

char*	a_UTF8toCP1251(const char *fstr, char *astr, int n) {
	int		i = 0;
	char	*tmp = astr;
	const unsigned char *s = (const unsigned char*)fstr;

	while (i < n && *s) {
		if (*s & 0x80) {
			if ((*s == 0xd1) && (*(s+1) == 0x91)) {	*tmp = 0xb8; }		// 
			else if ((*s == 0xd0) && (*(s+1) == 0x81)) { *tmp = 0xa8; }	// 
			else { *tmp = (*s + 48)*64 + *(s+1) + 48; }
			s += 2;
			tmp++;
		} else {
			*tmp++ = *s++;
		}
		i++;
	}

	*tmp = 0;

	return astr;
}







char*	a_strndel(char *astr, int p, int n) {

	while (astr[p + n]) {
		astr[p] = astr[p + n];
		p++;
	}
	astr[p] = 0;

	return astr;
}

WCHAR*	w_strndel(WCHAR *ustr, int p, int n) {

	while (ustr[p + n]) {
		ustr[p] = ustr[p + n];
		p++;
	}
	ustr[p] = 0;

	return ustr;
}





char*	a_ltrim(char *astr, char junk) {
	int	i = 0, n = 0;

	while (astr[n] == junk) { n++; }
	while (astr[n + i]) { astr[i] = astr[n + i]; i++; }
	astr[n + i] = 0;

	return astr;
}

WCHAR*	w_ltrim(WCHAR *ustr, WCHAR junk) {
	int	i = 0, n = 0;

	while (ustr[n] == junk) { n++; }
	while (ustr[n + i]) { ustr[i] = ustr[n + i]; i++; }
	ustr[n + i] = 0;

	return ustr;
}

char*	a_rtrim(char *astr, char junk) {
	int	i = strlen(astr) - 1;

	while ((astr[i] == junk) && (i > 0)) { i--; }
	astr[i + 1] = 0;

	return astr;
}

WCHAR*	w_rtrim(WCHAR *ustr, WCHAR junk) {
	int	i = u_strlen(ustr) - 1;

	while ((ustr[i] == junk) && (i > 0)) { i--; }
	ustr[i + 1] = 0;

	return ustr;
}

char*	a_trim(char *astr, char junk) {
	int	i = 0, n = 0;

	while (astr[i + n]) {
		if (astr[i + n] != junk) {
			astr[i] = astr[i + n];
			i++;
		} else {
			n++;
		}
	}
	astr[i] = 0;

	return astr;
}

WCHAR*	w_trim(WCHAR *ustr, WCHAR junk) {
	int	i = 0, n = 0;

	while (ustr[i + n]) {
		if (ustr[i + n] != junk) {
			ustr[i] = ustr[i + n];
			i++;
		} else {
			n++;
		}
	}
	ustr[i] = 0;

	return ustr;
}





int		a_chrcnt(char *astr, char junk) {
	int	i = 0, n = 0;

	while (astr[i]) {
		if (astr[i] == junk) { n++; }
		i++;
	}

	return n;
}

int		w_chrcnt(WCHAR *ustr, WCHAR junk) {
	int	i = 0, n = 0;

	while (ustr[i]) {
		if (ustr[i] == junk) { n++; }
		i++;
	}

	return n;
}





char*	a_replace(char *astr, char find, char repl) {
	int	i = 0;

	while (astr[i]) {
		if (astr[i] == find) { astr[i] = repl; }
		i++;
	}

	return astr;
}

WCHAR*	w_replace(WCHAR *ustr, WCHAR find, WCHAR repl) {
	int	i = 0;

	while (ustr[i]) {
		if (ustr[i] == find) { ustr[i] = repl; }
		i++;
	}

	return ustr;
}





WCHAR*	w_mkdir(WCHAR *dst, const WCHAR *uri) {
	int	i;

	i = u_strlen(uri) - 1;
	while (i >= 0 && uri[i] != L'/') i--;
	u_strncpy(dst, uri, i);					//  '/'  

	return dst;
}





//  dir  str,    "file:/"  
//        ,     
//     u_strcpy, u_strcat
WCHAR*	w_mkpath(WCHAR *dst, const WCHAR *dir, const WCHAR *str, BOOL fsprefix) {
	if (fsprefix && u_strncmp(dir, fs_prefix, 6) != 0) {
		const WCHAR* tmp;
		tmp = fs_prefix;
		while (*tmp != 0) { *dst++ = *tmp++; }
	}

	while (*dir != 0)	 { *dst++ = *dir++; }
	if (*(dst-1) != '/') { *dst++ = '/'; }
	if (*str == '/')	 { str++; }
	while (*str != 0)	 { *dst++ = *str++; }

	*dst = 0;

	return dst;
}





void*	w_fsread(const WCHAR *fn, UINT32 len, UINT32 *readen) {
    UINT32          size;
    FILE_HANDLE_T   file;
    void*           ptr = NULL;

    if ((file = DL_FsOpenFile(fn, FILE_READ_MODE, 0)) != FILE_HANDLE_INVALID) {
        size = DL_FsGetFileSize(file);
        if ((len > 0)&&(len < size)) { size = len; }
        if (size) {
        	//        
            ptr = _alloc(size + 4);
            memclr(ptr, size + 4);
            DL_FsReadFile(ptr, sizeof(UINT8), size, file, readen);
        }
        DL_FsCloseFile(file);
    } else {
		*readen = 0;
    }

    return ptr;
}

void*	a_fsread(const char *fn, UINT32 len, UINT32 *readen) {
    void*           path;
    void*           ptr;

    path = _alloc(FS_MAX_URI_NAME_LENGTH*2);

    w_atow(fn, (WCHAR*)path, FS_MAX_URI_NAME_LENGTH);
    ptr = w_fsread((WCHAR*)path, len, readen);

    _free(path);

    return ptr;
}





void*	w_fswrite(const WCHAR *fn, char *buf, UINT32 len, UINT32 *written) {
    UINT32          size;
    FILE_HANDLE_T   file;

    if ((file = DL_FsOpenFile(fn, FILE_WRITE_MODE, 0)) != FILE_HANDLE_INVALID) {
        size = strlen(buf);
        if ((len > 0)&&(len < size)) { size = len; }
        if (size) { DL_FsWriteFile(buf, sizeof(UINT8), size, file, written); }
        DL_FsCloseFile(file);
    }

    return buf;
}

void*	a_fswrite(const char *fn, char *buf, UINT32 len, UINT32 *written) {
    void*           path;
    void*           result;

    path = _alloc(FS_MAX_URI_NAME_LENGTH*2);

    w_atow(fn, (WCHAR*)path, FS_MAX_URI_NAME_LENGTH);
    result = w_fswrite((WCHAR*)path, buf, len, written);

    _free(path);

    return result;
}





UINT32	timerInit(UINT32 period, UINT32 id, BOOL cyclical, void *app) {
	IFACE_DATA_T	iface;

	if (!app) {
		iface.handle = 0;
	} else {
		iface.port = ((APPLICATION_T*)app)->port;
		iface.handle = 0;

		if (cyclical) {
			DL_ClkStartCyclicalTimer(&iface, period, id);
		} else {
			DL_ClkStartTimer(&iface, period, id);
		}
	}

	return iface.handle;
}





UINT32	timerDel(UINT32 *handle, void *app) {
	UINT32			result;
	IFACE_DATA_T	iface;

	if (handle && app) {
		iface.port = ((APPLICATION_T*)app)->port;
		iface.handle = *handle;

		result = DL_ClkStopTimer(&iface);

		if (!result) { *handle = 0; }
	} else {
		result = RESULT_FAIL;
	}

	return result;
}





UINT32	t_timerinit(void) {
	return (UINT32)suPalTicksToMsec(suPalReadTime());
}

UINT32	t_timerdiff(UINT32 timer, UINT32 now) {
	UINT32			t = now;

	if (!t) { t = t_timerinit(); }

	return t - timer;
}




void	a_time2dhm(UINT32 time, char *buf) {
	UINT32 d = time/86400000, h = (time/3600000) % 24, m = (time/60000) % 60;
	buf[0] = 0x30 + d / 10;
    buf[1] = 0x30 + d % 10;
    buf[2] = '\'';
    buf[3] = ' ';
    buf[4] = 0x30 + h / 10;
    buf[5] = 0x30 + h % 10;
    buf[6] = ':';
    buf[7] = 0x30 + m / 10;
    buf[8] = 0x30 + m % 10;
    buf[9] = 0;
}

void	a_time2hm(UINT32 time, char *buf) {
	UINT32 h = (time/3600000) % 24, m = (time/60000) % 60;
    buf[0] = 0x30 + h / 10;
    buf[1] = 0x30 + h % 10;
    buf[2] = ':';
    buf[3] = 0x30 + m / 10;
    buf[4] = 0x30 + m % 10;
    buf[5] = 0;
}

void	a_time2hms(UINT32 time, char *buf) {
    UINT32 h = (time/3600000) % 24, m = (time/60000) % 60, s = (time/1000) % 60;
    buf[0] = 0x30 + h / 10;
    buf[1] = 0x30 + h % 10;
    buf[2] = ':';
    buf[3] = 0x30 + m / 10;
    buf[4] = 0x30 + m % 10;
    buf[5] = ':';
    buf[6] = 0x30 + s / 10;
    buf[7] = 0x30 + s % 10;
    buf[8] = 0;
}

void	a_time2hmsms(UINT32 time, char *buf) {
    UINT32 h = (time/3600000) % 24, m = (time/60000) % 60, s = (time/1000) % 60, ms = time % 1000;
    buf[0] = 0x30 + h / 10;
    buf[1] = 0x30 + h % 10;
    buf[2] = ':';
    buf[3] = 0x30 + m / 10;
    buf[4] = 0x30 + m % 10;
    buf[5] = ':';
    buf[6] = 0x30 + s / 10;
    buf[7] = 0x30 + s % 10;
    buf[8] = '.';
    buf[9] = 0x30 + ms / 100;
    buf[10] = 0x30 + (ms / 10) % 10;
    buf[11] = 0x30 + ms % 10;
    buf[12] = 0;
}

UINT32	hms2time(UINT8 h, UINT8 m, UINT8 s) {
	return 1000*s + 60000*m + 3600000*h;
}




UINT32	now(void) {
#ifndef WIN32
	CLK_TIME_T	t;

	DL_ClkGetTime(&t);

	return 1000*t.second + 60000*t.minute + 3600000*t.hour;
#else
	return t_timerinit();
#endif
}




void*	_alloc(size_t size) {
	void	*result;

    //       4 
    if (size & 3) { size &= ~3; size += 4; }
    //         
	size += sizeof(uMemData) + sizeof(void*);

	result = suAllocMem(size, NULL);

	if (result) {
		((uMemData*)result)->prev = mem_last;
		((uMemData*)result)->next = NULL;
		((uMemData*)result)->size = size;
		//           
		*(void**)(result + size - sizeof(void*)) = result;
		//  
		mem_allocated += size;
		mem_blocks += 1;
		//   
		if (!mem_first) { mem_first = result; }
		//     
		if (mem_last) { mem_last->next = result; }
		//      
		mem_last = result;
		//     
		result += sizeof(uMemData);
	}

	return result;
}



void	_free(void *ptr) {

	if (ptr) {
		//   
		ptr -= sizeof(uMemData);
		//    (      size_t  )
		if (ptr == *(void**)(ptr + ((uMemData*)ptr)->size - sizeof(void*))) {
			//  
			mem_allocated -= ((uMemData*)ptr)->size;
			mem_blocks -= 1;
			//        (    )
			if (((uMemData*)ptr)->prev) { (((uMemData*)ptr)->prev)->next = ((uMemData*)ptr)->next; } else { mem_first = ((uMemData*)ptr)->next; }
			if (((uMemData*)ptr)->next) { (((uMemData*)ptr)->next)->prev = ((uMemData*)ptr)->prev; } else { mem_last = ((uMemData*)ptr)->prev; }
			//   
			suFreeMem(ptr);
		}
	}
}



UINT32	_leak(void) {

	return mem_allocated;
}

UINT32	_bleak(void) {

	return mem_blocks;
}



void	_cleanup(BOOL force) {
	uMemData	*mem_next;

	//      
	while (mem_first && (force || (((void*)mem_first) == *(void**)(((void*)mem_first) + mem_first->size - sizeof(void*))))) {
		//  
		mem_allocated -= mem_first->size;
		mem_blocks -= 1;
		//     
		mem_next = mem_first->next;
		//  
		suFreeMem(mem_first);
		//    
		mem_first = mem_next;
	}

	//         
	if (!mem_first) { mem_last = NULL; }
}

/* EOF */
