////////////////////////////////////////////////////////////////////////////////
//  

#define IS_DAEMON
// #define NULL_DLG
// #define USE_TASKS
#define USE_PM_EXIT
#define	DISP_ACTIVITY
#define	HOOK_KEYS






////////////////////////////////////////////////////////////////////////////////
// 

#define	TIMER_ID		0xDDEAD

#ifdef USE_TASKS
	#define TASK_PRIORITY   0x18
	#define TASK_STACK_SIZE 0x4000
	#define	TIMER_TIMEOUT	1
#else
	#define	TIMER_TIMEOUT	100
#endif

#define	ELF_NAME		"DeskUtils"
#define DEBUG_APP_NAME	"DeskUtils"

#define DBG_TO_LOGFILE
#define LOG_FILE		L"file://b/DeskUtils.log"

#ifndef IS_DAEMON
	#define GDI_DOUBLEBUFFER	1
#else
	#define	GDI_DOUBLEBUFFER	0
#endif






////////////////////////////////////////////////////////////////////////////////
//  

#include <tadbg.h>
#include <DAL.h>
#include <mem.h>
#include <tasks.h>
#include <utilities.h>
#include <alarm.h>
#include <filesystem.h>

#include "elf.h"
#include "bmp.h"
#include "gdi.h"
#include "misc.h"
#include "cfg.h"
#include "defines.h"

// #include <.h>
// #include ".h"





////////////////////////////////////////////////////////////////////////////////
//  , , 

//   
typedef UINT8 APP_STATES_T;

//  
enum APP_STATES_ENUM {
	APP_STATE_ANY,

#ifndef IS_DAEMON
	APP_STATE_INIT,
#endif
	APP_STATE_MAIN,

	APP_STATE_MAX
};

enum APP_STATE_CHANGE {
	APP_ENTER,
	APP_SUSPEND,
	APP_RESUME,
	APP_EXIT
};





////////////////////////////////////////////////////////////////////////////////
//  

static	UINT32	AppStart(EVENT_STACK_T *ev_st, REG_ID_T reg_id, UINT32 param2);
static	UINT32	AppExit(EVENT_STACK_T *ev_st, APPLICATION_T *app);

static	UINT32	ResInit(void);
static	UINT32	ResFree(void);

#ifndef IS_DAEMON
static	UINT32	AppChangeState(EVENT_STACK_T *ev_st, APPLICATION_T *app, UINT32 state);

static	UINT32	MainStateEnter(EVENT_STACK_T *ev_st, APPLICATION_T *app, ENTER_STATE_TYPE_T type);
static	UINT32	MainStateExit(EVENT_STACK_T *ev_st, APPLICATION_T *app, EXIT_STATE_TYPE_T type);

static	UINT32	HandleUITokenGranted(EVENT_STACK_T *ev_st,  APPLICATION_T *app );
#endif

#ifdef DISP_ACTIVITY
static	UINT32	HandleDispActivate(EVENT_STACK_T *ev_st, APPLICATION_T *app);
static	UINT32	HandleDispDeactivate(EVENT_STACK_T *ev_st, APPLICATION_T *app);
#endif

#ifdef HOOK_KEYS
static	UINT32	HandleKeyPress(EVENT_STACK_T *ev_st, APPLICATION_T *app);
//static	UINT32	HandleKeyRelease(EVENT_STACK_T *ev_st, APPLICATION_T *app);
#endif

#ifdef USE_PM_EXIT
static	UINT32	HandleExit(EVENT_STACK_T *ev_st, APPLICATION_T *app);
#endif

#ifndef USE_TASKS
static	UINT32	HandleTimerExpiried(EVENT_STACK_T *ev_st, APPLICATION_T *app);
#endif

static	void	MainTask(void *arg);

static	UINT32	HandleBTConnect(EVENT_STACK_T* ev_st,  APPLICATION_T* app);
//static	UINT32	HandleBTPower(EVENT_STACK_T* ev_st,  APPLICATION_T* app);

static	inline	void	update(void);
static	inline	void	update_rect(void);

static	void	update_data(void);

static	inline	void	GetNextAlarm(UINT32 time, UINT32 *alarm, BOOL *state);
static	inline	UINT32	GetColorByPercent(UINT32 half, UINT32 full);

//static	UINT32	Handle(EVENT_STACK_T *ev_st, APPLICATION_T *app);





////////////////////////////////////////////////////////////////////////////////
//    

//  .       
const char	app_name[APP_NAME_LEN] = ELF_NAME;

//       .    .
WCHAR		workdir[FS_MAX_URI_NAME_LENGTH+1];

// ,   .
APPLICATION_T*		app;

UINT32		evcode_base, app_active = false, task_active = false;
ldrElf		elf;





////////////////////////////////////////////////////////////////////////////////
//   
RECT_T			cbkRect = {0, 0, 176, 220};

// 
uCfg			conf;

UINT32			SEEM004A, KEYLOCK, hTimer;

//       
uGDIContext		hDC;
uGDIBitmap		hBg;
uGDIAnimation	hClkIcon, hBTIcon, hBatIcon, hSigIcon, hAlrIcon, hFlashIcon, hDrvIcon;

uAppData		data = {{{0, 30}, {0, 48}, {88, 66}, {0, 66}, {88, 88}, {0, 88}},
						{ {true, true, "", "00:00:00:00:00:00", false, 0},
						  {true, true, KEY_7, 0, 0, false, "00:00:00.000"},
						  {true, true, 0, 0, 0, 0x88, 0xB8, "0%", "0.00V"},
						  {true, true, -103, -60, {0, 0}, false, false, "0%", "0dBm"},
						  {true, true, false, 0, "00:00", 0, "00:00:00"},
						  {true, true, false, L"", NULL, 0} }};

//  
UINT8			activedlg = 0, locked = 0;

extern	unsigned	char	SBCM_ATOD_supply;
extern	unsigned	char	*SBCM_ATOD_vltg;

extern	unsigned short	bat;
extern	unsigned short	sig;
extern	unsigned short	bt;
extern	unsigned short	clk;
extern	unsigned short	alr;
extern	unsigned short	flsh;
extern	unsigned short	drv;

//UIS_DIALOG_T	hWnd;





////////////////////////////////////////////////////////////////////////////////
//     state-

//    APP_STATE_ANY (   state)
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
#ifndef IS_DAEMON
	{ EV_REVOKE_TOKEN,		APP_HandleUITokenRevoked	},
#endif

#ifdef USE_PM_EXIT
	{ EV_PM_API_EXIT,		HandleExit					},		// PM API: cmd EXIT
#endif

	//      
	{ STATE_HANDLERS_END,	NULL						}
};

#ifndef IS_DAEMON
static EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
	{ EV_GRANT_TOKEN,		HandleUITokenGranted		},		//  Token'

	//      
	{ STATE_HANDLERS_END,	NULL						}
};
#endif

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
	{ EV_KEY_PRESS,			HandleKeyPress				},		//  

	{ EV_DISPLAY_ACTIVE,	HandleDispActivate			},		//  
	{ EV_DISPLAY_NO_ACTIVE,	HandleDispDeactivate		},		//  

#ifndef USE_TASKS
	{ EV_TIMER_EXPIRED,		HandleTimerExpiried 		},		//  
#endif

	{ 0x820b0,				HandleBTConnect				},
//	{ EV_BT_POWER,			HandleBTPower				},

	//      
	{ STATE_HANDLERS_END,	NULL						}
};





////////////////////////////////////////////////////////////////////////////////
//   ,    -  .
//    ,   enum-e

static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
	{ APP_STATE_ANY,		// State
		NULL,				//    state
		NULL,				//    state
		any_state_handlers },

#ifndef IS_DAEMON
	{ APP_STATE_INIT,
		NULL,
		NULL,
		init_state_handlers },
#endif

	{ APP_STATE_MAIN,
#ifndef IS_DAEMON
		MainStateEnter,
		MainStateExit,
#else
		NULL,
		NULL,
#endif
		main_state_handlers }
};





////////////////////////////////////////////////////////////////////////////////
//  EntryPoint   ,     
// uri -    ( argv[0])
// params -   (  argv)
ldrElf*	_start(WCHAR *uri, WCHAR *params) {

	UINT32				reserve, status = RESULT_OK;
	UINT8				i;

	//    
	uri = uri;
	params = params;

	dbg("_start: Enter");

	// ,    ?
	if (ldrIsLoaded((char*)app_name)) { cprint("\x87" ELF_NAME ":\x8c Already Loaded!\n"); return NULL; }

	evcode_base = ldrRequestEventBase();
	elf.evbase = evcode_base;

	//   
	reserve = evcode_base + 1;
	for (i = 0; i < sizeof(state_handling_table)/sizeof(STATE_HANDLERS_ENTRY_T); i++ ) {
		reserve = ldrInitEventHandlersTbl((EVENT_HANDLER_ENTRY_T *)state_handling_table[i].htable, reserve);
	}

	//  
	status = APP_Register(	&evcode_base,			//      
							1,						// - ,     
							state_handling_table,	//  
							APP_STATE_MAX,			//  
							(void*)AppStart );		// ,   

	dbgf("_start: APP_Register, status = %d", status);

	//    ,    
	w_mkdir(workdir, uri);

	elf.name = (char*)app_name;
	ldrSendEvent(evcode_base); //  

	dbg("_start: Exit");

	return &elf;
}





//     
UINT32	AppStart(EVENT_STACK_T *ev_st, REG_ID_T reg_id, UINT32 param2) {
	UINT32				result = RESULT_OK;

	dbg("AppStart: Enter");

#ifdef IS_DAEMON
	//    
	app = APP_InitAppData(	(void*)APP_HandleEventPrepost,	//    
                            sizeof(APPLICATION_T),
                            reg_id,
                            0, 0,
                            1,
                            AFW_APP_CENTRICITY_NONE,
							AFW_PREPROCESSING,
							AFW_POSITION_TOP );
#else
	//    
	app = APP_InitAppData(	(void*)APP_HandleEvent,			//   
							sizeof(APPLICATION_T),
							reg_id,
							0, 0,
							1,
							AFW_APP_CENTRICITY_PRIMARY,
							AFW_FOCUS,
							AFW_POSITION_TOP );
#endif

	dbgf("AppStart: APP_InitAppData, app = 0x%X", app);

	//       
	if (!app) { cprint("\x87" ELF_NAME ":\x8c Init Failed!\n"); return ldrUnloadElf(); }

	result = APP_Start( ev_st, app,
#ifdef IS_DAEMON
						APP_STATE_MAIN,								//     
#else
						APP_STATE_INIT,								//    
#endif
						state_handling_table,
						AppExit,
						app_name,
						0 );

	dbgf("AppStart: APP_Start, result = 0x%X", result);

	elf.app = app;

	if (!result) {
		//  
		GDI_Init(&hDC, app_name, app, GDI_PRIVATEDC, AHIROP_PATCOPY, AHIROP_PATCOPY, GDI_DOUBLEBUFFER);
		//  .
		result = ResInit();
		//      -    .
		if (result) {
			cprint("\x87" ELF_NAME ":\x8c Init Res Failed!\n");
			APP_HandleFailedAppStart(ev_st, app, 0);
			return ldrUnloadElf();
		}
#ifdef USE_TASKS
		//  
		suCreateTask(MainTask, TASK_STACK_SIZE, TASK_PRIORITY);
#else
		//  
		hTimer = timerInit(TIMER_TIMEOUT, TIMER_ID, true, app);
#endif
#ifdef IS_DAEMON
		//    (   -   Main state)
		app_active = true;
#endif
	} else {
		cprint("\x87" ELF_NAME ":\x8c Start Failed!\n");
		APP_HandleFailedAppStart(ev_st, app, 0);
		return ldrUnloadElf();
	}

	dbg("AppStart: Exit");

	return RESULT_OK;
}


//    
UINT32	AppExit(EVENT_STACK_T *ev_st,  APPLICATION_T *app) {
	UINT32				result, leak, bleak, forced = false, free = 0, bfree = 0;

	dbg("AppExit: Enter");

#ifdef IS_DAEMON
	//   
	app_active = false;
#endif
#ifdef USE_TASKS
	//   
	while (task_active) { suSleep(1, &result); }
#else
	//  
	timerDel(&hTimer, app);
#endif

	//   
	ResFree();
	//  
	GDI_UnInit(&hDC);

	//        
	leak = _leak();
	bleak = _bleak();
	if (leak || bleak) {
		//    
		cprintf("\n\x87" ELF_NAME ":\x8e Memory leak detected!\n", leak);
		//  
		_cleanup(forced);
		// ,   
		free = _leak();
		bfree = _bleak();
		if (free || bfree) {
			//   
			forced = true;
			//     
			cprintf("\x87" ELF_NAME ":\x8c Forced clean used!\n", leak);
			// 
			_cleanup(forced);
			//    
			free = _leak();
			bfree = _bleak();
		}
		//     
		cprintf("\x87" ELF_NAME ":\x87 Memory freed:\n" ELF_NAME ": - %d of %d bytes\n" ELF_NAME ": - %d of %d blocks\n", leak - free, leak, bleak - bfree, bleak);
		if (free || bfree) {
			cprint("\x87" ELF_NAME ":\x8c Done with errors\n");
		} else if (forced) {
			cprint("\x87" ELF_NAME ":\x8e Done with warnings\n");
		} else {
			cprint("\x87" ELF_NAME ":\x8a Done\n");
		}
	}

	//   
	result = APP_ExitStateAndApp(ev_st, app, 0);

	dbgf("AppExit: Exit, result = %d, leak = %d, block = %d, left = %d, forced = %d", result, leak, bleak, free, forced);

	//  
	return ldrUnloadElf();
}






//    
UINT32	ResInit(void) {
	UINT32		result = RESULT_OK;
	WCHAR		*path = _alloc(sizeof(WCHAR)*FILEURI_MAX_LEN);
	WCHAR		config[14] = L"DeskUtils.ini\0";
	char		*buf;

	dbg(" ResInit: Enter");

#ifndef WIN32
	SEEM004A = ldrGetConstVal(BEGIN_4A__IN_DB);
	KEYLOCK = ldrGetConstVal(KEYPAD_STATE);
#endif

	sprintf(data.info.bluetooth.sz_addr, "00:00:00:00:00:00");

	GDI_CreateAniBitmapFromBinary(&hDC, &hClkIcon, (void*)&clk, 48, 16, AHIFMT_16BPP_565);
	GDI_CreateAniBitmapFromBinary(&hDC, &hBTIcon, (void*)&bt, 64, 16, AHIFMT_16BPP_565);
	GDI_CreateAniBitmapFromBinary(&hDC, &hBatIcon, (void*)&bat, 160, 16, AHIFMT_16BPP_565);
	GDI_CreateAniBitmapFromBinary(&hDC, &hSigIcon, (void*)&sig, 112, 16, AHIFMT_16BPP_565);
	GDI_CreateAniBitmapFromBinary(&hDC, &hAlrIcon, (void*)&alr, 32, 16, AHIFMT_16BPP_565);
	GDI_CreateAniBitmapFromBinary(&hDC, &hFlashIcon, (void*)&flsh, 32, 16, AHIFMT_16BPP_565);
	GDI_CreateAniBitmapFromBinary(&hDC, &hDrvIcon, (void*)&drv, 16, 16, AHIFMT_16BPP_565);

	hClkIcon.active = hBTIcon.active = hBatIcon.active = hSigIcon.active = hAlrIcon.active = hFlashIcon.active = false;
	hClkIcon.transparent = hBTIcon.transparent = hBatIcon.transparent = hSigIcon.transparent = hAlrIcon.transparent = hFlashIcon.transparent = true;

	//  
	w_mkpath(path, workdir, config, true);

	cfgOpen(&conf, path);

	data.info.bluetooth.show = cfgGetValueBool(&conf, "bluetooth.show", true);
	data.info.bluetooth.show_icon = cfgGetValueBool(&conf, "bluetooth.show_icon", true);
	data.pos.bluetooth.x = cfgGetValueUInt(&conf, "bluetooth.pos.x", 0);
	data.pos.bluetooth.y = cfgGetValueUInt(&conf, "bluetooth.pos.y", 30);

	data.info.stopwatch.show = cfgGetValueBool(&conf, "stopwatch.show", true);
	data.info.stopwatch.show_icon = cfgGetValueBool(&conf, "stopwatch.show_icon", true);
	data.info.stopwatch.key = (char)cfgGetValueUInt(&conf, "stopwatch.key", KEY_7);
	data.pos.stopwatch.x = cfgGetValueUInt(&conf, "stopwatch.pos.x", 0);
	data.pos.stopwatch.y = cfgGetValueUInt(&conf, "stopwatch.pos.y", 48);

	data.info.battery.show = cfgGetValueBool(&conf, "battery.show", true);
	data.info.battery.show_icon = cfgGetValueBool(&conf, "battery.show_icon", true);
	data.pos.battery.x = cfgGetValueUInt(&conf, "battery.pos.x", 88);
	data.pos.battery.y = cfgGetValueUInt(&conf, "battery.pos.y", 66);
	data.info.battery.min = (char)cfgGetValueUInt(&conf, "battery.min", 0x88);
	data.info.battery.max = (char)cfgGetValueUInt(&conf, "battery.max", 0xB8);

	data.info.signal.show = cfgGetValueBool(&conf, "signal.show", true);
	data.info.signal.show_icon = cfgGetValueBool(&conf, "signal.show_icon", true);
	data.pos.signal.x = cfgGetValueUInt(&conf, "signal.pos.x", 0);
	data.pos.signal.y = cfgGetValueUInt(&conf, "signal.pos.y", 66);
	data.info.signal.air_patch = cfgGetValueBool(&conf, "signal.air_patch", false);

	data.info.alarm.show = cfgGetValueBool(&conf, "alarm.show", true);
	data.info.alarm.show_icon = cfgGetValueBool(&conf, "alarm.show_icon", true);
	data.pos.alarm.x = cfgGetValueUInt(&conf, "alarm.pos.x", 88);
	data.pos.alarm.y = cfgGetValueUInt(&conf, "alarm.pos.y", 88);

	data.info.drive.show = cfgGetValueBool(&conf, "drive.show", true);
	data.info.drive.show_icons = cfgGetValueBool(&conf, "drive.show_icons", true);
	data.pos.drive.x = cfgGetValueUInt(&conf, "drive.pos.x", 0);
	data.pos.drive.y = cfgGetValueUInt(&conf, "drive.pos.y", 88);

	buf = cfgGetValue(&conf, "drive.drives", NULL);
	if (buf && strlen(buf)) {
		data.info.drive.predefined = true;
		w_atow(buf, data.info.drive.drives, 32);
	} else {
		data.info.drive.predefined = false;
	}

	cfgClose(&conf);

	_free(path);

	dbgf(" ResInit: Exit, result = %d", result);

	return result;
}


//    
UINT32	ResFree(void) {
	UINT32		result = RESULT_OK;

	dbg(" ResFree: Enter");

	GDI_UnLoadAniBitmap(&hDC, &hDrvIcon);
	GDI_UnLoadAniBitmap(&hDC, &hFlashIcon);
	GDI_UnLoadAniBitmap(&hDC, &hAlrIcon);
	GDI_UnLoadAniBitmap(&hDC, &hSigIcon);
	GDI_UnLoadAniBitmap(&hDC, &hBatIcon);
	GDI_UnLoadAniBitmap(&hDC, &hBTIcon);
	GDI_UnLoadAniBitmap(&hDC, &hClkIcon);

	dbgf(" ResFree: Exit, result = %d", result);

	return result;
}





#ifndef IS_DAEMON
// ,    
UINT32	AppChangeState(EVENT_STACK_T *ev_st, APPLICATION_T *app, UINT32 state) {
	UINT32		result = RESULT_OK;

#ifndef NULL_DLG
	//  Canvas'.  NULL-  .
	DRAWING_BUFFER_T		bufd = {NULL, 176, 220};
#endif

	dbgf(" AppChangeState: Enter, state = %d", state);

	switch (state) {
		case APP_ENTER:
			//    Main
#ifdef NULL_DLG
#ifndef WIN32
			//  -...      EmuElf  !
			setCanvasControl__13StatusManagerFScPUs(&theStatusManager, TRUE, NULL);
#endif
			//  NULL-.
			hWnd = UIS_CreateNullDialog(&app->port);
#else
			//  Canvas.     ...
			hWnd = UIS_CreateColorCanvas(&app->port, &bufd, TRUE);
#endif
			//      app
			if (hWnd) {
				app->dialog = hWnd;
				dbgf(" AppChangeState: dialog = 0x%08x", hWnd);
			} else {
				result = RESULT_FAIL;
			}
			break;
		case APP_SUSPEND:
			//  
			if (hDC.surfswap) { GDI_SwapSurfaces(&hDC); }
			app_active = false;
			break;
		case APP_RESUME:
			//  
			app_active = true;
			break;
		case APP_EXIT:
			//    Main
			if (hWnd) {
				APP_UtilUISDialogDelete(&hWnd);
				hWnd = 0;
			}
			break;
	}

	dbgf(" AppChangeState: Exit, result = %d", result);

	return result;
}


//    MainState
UINT32	MainStateEnter(EVENT_STACK_T *ev_st, APPLICATION_T *app, ENTER_STATE_TYPE_T type) {
	UINT32					result = RESULT_OK;

	dbgf("MainStateEnter: Enter, type = %d", type);

	switch (type) {
		case ENTER_STATE_ENTER:
			//  
			result = AppChangeState(ev_st, app, APP_ENTER);
			break;
		case ENTER_STATE_RESUME:
			//  
			result = AppChangeState(ev_st, app, APP_RESUME);
			break;
	}

	dbg("MainStateEnter: Exit");

	return result;
}


//     Main
UINT32	MainStateExit(EVENT_STACK_T *ev_st, APPLICATION_T *app, EXIT_STATE_TYPE_T type) {
	UINT32					result = RESULT_OK;

	dbgf("MainStateExit: Enter, type = %d", type);

	switch (type) {
		case EXIT_STATE_EXIT:
			//  
			result = (AppChangeState(ev_st, app, APP_SUSPEND) | AppChangeState(ev_st, app, APP_EXIT));
			break;
		case EXIT_STATE_SUSPEND:
			//  
			result = AppChangeState(ev_st, app, APP_SUSPEND);
			break;
	}

	dbg("MainStateExit: Exit");

	return result;
}


//  Token'
UINT32	HandleUITokenGranted(EVENT_STACK_T *ev_st,  APPLICATION_T *app) {
	UINT32					result = RESULT_OK;

	dbg("HandleUITokenGranted: Enter");

	//    
	result = APP_HandleUITokenGranted(ev_st, app);
	dbgf("HandleUITokenGranted: APP_HandleUITokenGranted, result = %d", result);

	//   ,   state
	if ((result == RESULT_OK) && (app->token_status == 2)) {
		result = APP_UtilChangeState(APP_STATE_MAIN, ev_st, app);
	}

	dbgf("HandleUITokenGranted: Exit, result = %d", result);

	return result;
}
#endif




#ifdef DISP_ACTIVITY
UINT32	HandleDispActivate(EVENT_STACK_T *ev_st, APPLICATION_T *app) {
	UINT32					result = RESULT_OK;

	dbg("HandleDispActivate: Enter");

	app_active = true;

	dbgf("HandleDispActivate: Exit, result = %d", result);

	return result;
}


UINT32	HandleDispDeactivate(EVENT_STACK_T *ev_st, APPLICATION_T *app) {
	UINT32					result = RESULT_OK;

	dbg("HandleDispDeactivate: Enter");

	app_active = false;

	dbgf("HandleDispDeactivate: Exit, result = %d", result);

	return result;
}
#endif




#ifdef HOOK_KEYS
//    
UINT32	HandleKeyPress( EVENT_STACK_T *ev_st,  APPLICATION_T *app ) {
	//   
	UINT8	key = GET_KEY(ev_st);

	dbgf("HandleKeyPress: Enter, key = 0x%X", key);

	if (key == data.info.stopwatch.key) {
		//  
		//update_data();
		//   
		if ((!locked)&&(activedlg == DialogType_Homescreen)) {
			if (data.info.stopwatch.started) {
				data.info.stopwatch.started = false;
				data.info.stopwatch.timems = t_timerdiff(data.info.stopwatch.timestamp, 0);
				hClkIcon.frame = 2;
			} else {
				if (data.info.stopwatch.timestamp) {
					data.info.stopwatch.started = false;
					data.info.stopwatch.timestamp = 0;
					data.info.stopwatch.timems = 0;
					hClkIcon.frame = 0;
				} else {
					data.info.stopwatch.started = true;
					data.info.stopwatch.timems = 0;
					data.info.stopwatch.timestamp = t_timerinit();
					hClkIcon.frame = 1;
				}
			}
			a_time2hmsms(data.info.stopwatch.timems, data.info.stopwatch.sz_time);
			//  -
			APP_ConsumeEv(ev_st, app);
		}
	}

#ifdef WIN32
    if (key == KEY_STAR) {
        app->exit_status = true;
    }
#endif

	dbg("HandleKeyPress: Exit");

	return RESULT_OK;
}





/*   
UINT32	HandleKeyRelease(EVENT_STACK_T *ev_st,  APPLICATION_T *app) {
	//   
	UINT8	key = GET_KEY(ev_st);

	dbgf("HandleKeyRelease: Enter, key = 0x%X", key);

	//  -
	APP_ConsumeEv(ev_st, app);

	dbg("HandleKeyRelease: Exit");

	return RESULT_OK;
}*/
#endif




#ifndef USE_TASKS
//    
UINT32	HandleTimerExpiried(EVENT_STACK_T *ev_st, APPLICATION_T *app) {
	//   
	UINT32		tid = GET_TIMER_ID(ev_st);

	switch (tid) {
		case TIMER_ID:
			MainTask(app);
			APP_ConsumeEv(ev_st, app);
			break;
	}

	return RESULT_OK;
}
#endif





#ifdef USE_PM_EXIT
// PM API: Exit -      
UINT32	HandleExit(EVENT_STACK_T *ev_st,  APPLICATION_T *app) {

	dbg("HandleExit: Enter");

	APP_ConsumeEv(ev_st, app);
	app->exit_status = TRUE;

	dbg("HandleExit: Exit");

	return RESULT_OK;
}
#endif





void	MainTask(void *arg) {
	UINT32		i;
#ifdef USE_TASKS
	UINT32		sleep;

	//    
	task_active = true;

	//         
	while (!app->exit_status) {
#endif
		if (app_active) {
			//     
			update();
			//   , ...
			if (activedlg == DialogType_Homescreen) {
				// ... 
				update_data();
				update_rect();
				//    
				if (!hBg.bitmap.image) { GDI_RenderRegionToBitmap(&hDC, &hBg, true); }
				if (GDI_BeginPaint(&hDC)) {
					GDI_RenderBitmap(&hDC, &hBg, hDC.region.x1, hDC.region.y1);

					// 
					if (data.info.stopwatch.show) {
						if (data.info.stopwatch.show_icon) {
							GDI_RenderAniBitmapTrans(&hDC, &hClkIcon, data.pos.stopwatch.x, data.pos.stopwatch.y);
						}

						if (data.info.stopwatch.started) { data.info.stopwatch.timems = t_timerdiff(data.info.stopwatch.timestamp, 0);  }
						if (data.info.stopwatch.timestamp) { a_time2hmsms(data.info.stopwatch.timems, data.info.stopwatch.sz_time); }

						GDI_RenderString(&hDC, data.info.stopwatch.sz_time, data.pos.stopwatch.x + ((data.info.stopwatch.show_icon) ? 16 + 2 : 0), data.pos.stopwatch.y + (16 - 10)/2, 0xffff, 1);
					}

					//   BlueTooth
					if (data.info.bluetooth.show) {
						if (data.info.bluetooth.show_icon) {
							GDI_RenderAniBitmapTrans(&hDC, &hBTIcon, data.pos.bluetooth.x, data.pos.bluetooth.y);
						}

						GDI_RenderString(&hDC, data.info.bluetooth.sz_addr, data.pos.bluetooth.x + ((data.info.bluetooth.show_icon) ? 16 + 2 : 0), data.pos.bluetooth.y + (16 - 10)/2, (data.info.bluetooth.status == BTS_CONNECTED) ? 0x07e0 : 0xffff, 1);
					}

					//   
					if (data.info.battery.show) {
						if (data.info.battery.show_icon) {
							GDI_RenderAniBitmapTrans(&hDC, &hBatIcon, data.pos.battery.x, data.pos.battery.y);
						}

						GDI_RenderString(&hDC, data.info.battery.sz_percent, data.pos.battery.x + ((data.info.battery.show_icon) ? 16 + 2 : 0), data.pos.battery.y + 16/2 - 10, 0xffff, 1);
						GDI_RenderString(&hDC, data.info.battery.sz_voltage, data.pos.battery.x + ((data.info.battery.show_icon) ? 16 + 2 : 0), data.pos.battery.y + 16/2, 0xffff, 1);
					}

					//   
					if (data.info.signal.show) {
						if (data.info.signal.show_icon) {
							GDI_RenderAniBitmapTrans(&hDC, &hSigIcon, data.pos.signal.x, data.pos.signal.y);
						}

						GDI_RenderString(&hDC, data.info.signal.sz_dbm, data.pos.signal.x + ((data.info.signal.show_icon) ? 16 + 2 : 0), data.pos.signal.y + ((data.info.signal.airplane) ? (16 - 10)/2 : 16/2), 0xffff, 1);

						if (!data.info.signal.airplane) { GDI_RenderString(&hDC, data.info.signal.sz_percent, data.pos.signal.x + ((data.info.signal.show_icon) ? 16 + 2 : 0), data.pos.signal.y + 16/2 - 10, 0xffff, 1); }
					}

					//   
					if (data.info.alarm.show) {
						if (data.info.alarm.show_icon) {
							GDI_RenderAniBitmapTrans(&hDC, &hAlrIcon, data.pos.alarm.x, data.pos.alarm.y);
						}

						GDI_RenderString(&hDC, data.info.alarm.sz_time, data.pos.alarm.x + ((data.info.alarm.show_icon) ? 16 + 2 : 0), data.pos.alarm.y + ((data.info.alarm.active) ? 16/2 - 10 : (16 - 10)/2), ((data.info.alarm.active) ? 0xfff3 : 0xffff), 1);

						if (data.info.alarm.active) {
							data.info.alarm.left = t_timerdiff(now(), data.info.alarm.time);
							a_time2hms(data.info.alarm.left, data.info.alarm.sz_left);
							GDI_RenderString(&hDC, data.info.alarm.sz_left, data.pos.alarm.x + ((data.info.alarm.show_icon) ? 16 + 2 : 0), data.pos.alarm.y + 16/2, 0xffff, 1);
						}
					}

					//   
					if (data.info.drive.show) {
						if (data.info.drive.show_icons) {
							for (i = 0; i < data.info.drive.count; i++) {
								if (!(data.info.drive.data[i].desc.device & FS_DEVICE_FLASH) && data.info.drive.data[i].desc.free) { hFlashIcon.frame = 1; } else { hFlashIcon.frame = 0; }
								GDI_RenderAniBitmapTrans(&hDC, ((data.info.drive.data[i].desc.device & FS_DEVICE_FLASH) ? &hDrvIcon : &hFlashIcon), data.pos.drive.x, data.pos.drive.y + i*18);
							}
						}

						for (i = 0; i < data.info.drive.count; i++) {
							GDI_RenderString(&hDC, data.info.drive.data[i].sz_space, data.pos.drive.x + ((data.info.drive.show_icons) ? 16 + 2 : 0), data.pos.drive.y + i*18 + (16 - 10)/2, data.info.drive.data[i].color, 1);
						}
					}

					GDI_EndPaint(&hDC);
				}
			} else if (hBg.bitmap.image) { GDI_UnLoadBitmap(&hDC, &hBg); }
		}
#ifdef USE_TASKS
		suSleep(TIMER_TIMEOUT, &sleep);
	}

	//    
	task_active = false;
#endif
}





UINT32	HandleBTConnect(EVENT_STACK_T* ev_st,  APPLICATION_T* app) {

	EVENT_T		*event = AFW_GetEv(ev_st);
	uBTConnect	*btc = event->attachment;
	UINT32		i;

	if (btc) {
		data.info.bluetooth.sz_addr[0] = 0;
		for (i = 0; i < 6; i++) { data.info.bluetooth.addr[i] = btc->addr[i]; }
		data.info.bluetooth.power = 1;
		data.info.bluetooth.status = btc->status;
		sprintf(data.info.bluetooth.sz_addr, "%02x:%02x:%02x:%02x:%02x:%02x", data.info.bluetooth.addr[0], data.info.bluetooth.addr[1], data.info.bluetooth.addr[2], data.info.bluetooth.addr[3], data.info.bluetooth.addr[4], data.info.bluetooth.addr[5]);
	}

	if (data.info.bluetooth.status == BTS_CONNECTED) { hBTIcon.frame = 2; } else { hBTIcon.frame = 1; }

	return RESULT_OK;
}

/*UINT32	HandleBTPower(EVENT_STACK_T* ev_st,  APPLICATION_T* app) {

	data.info.bluetooth.power = *(char*)(((EVENT_T*)AFW_GetEv(ev_st))->attachment);

	if (data.info.bluetooth.power) { hBTIcon.frame = 1; } else { hBTIcon.frame = 0; }

	return RESULT_OK;
}*/







void	update(void) {
	//    ( - )
#ifndef WIN32
	DL_DbFeatureGetCurrentState(KEYLOCK, &locked);
#else
	locked = false;
#endif

	//   
#ifndef WIN32
	UIS_GetActiveDialogType(&activedlg);
#else
	activedlg = DialogType_Homescreen;
#endif
}




void	update_rect(void) {
	hDC.region.x1 = min(min(min(min(min(data.pos.bluetooth.x, data.pos.stopwatch.x), data.pos.battery.x), data.pos.signal.x), data.pos.alarm.x), data.pos.drive.x);
	hDC.region.y1 = min(min(min(min(min(data.pos.bluetooth.y, data.pos.stopwatch.y), data.pos.battery.y), data.pos.signal.y), data.pos.alarm.y), data.pos.drive.y);
	hDC.region.x2 = DISPLAY_WIDTH;
	hDC.region.y2 = max(max(max(max(max(data.pos.bluetooth.y, data.pos.stopwatch.y), data.pos.battery.y), data.pos.signal.y), data.pos.alarm.y), data.pos.drive.y + (data.info.drive.count - 1)* 18) + 18;
}





void	update_data(void) {
	INT32		readen, kb, mb, gb;
	UINT8		prev, i;

	//   
	prev = data.info.battery.vltg;
#ifndef WIN32
	data.info.battery.supply = SBCM_ATOD_supply;
	data.info.battery.vltg = *SBCM_ATOD_vltg;
#else
	data.info.battery.supply = random(2);
	data.info.battery.vltg = 0xA0 + random(32);
#endif
	if (prev != data.info.battery.vltg) {
		//  
		readen = 100*(data.info.battery.vltg - data.info.battery.min)/(data.info.battery.max - data.info.battery.min);
		if (readen < 0) { readen = 0; } else if (readen > 100) { readen = 100; }
		//     
		data.info.battery.percent = (char)readen;
		//    
		hBatIcon.frame = (readen < 99) ? ((readen > 10) ? (readen / 10) : 0) : 9;
		sprintf(data.info.battery.sz_percent, "%d%%", readen);
		//  
		readen = data.info.battery.vltg + 231;
		sprintf(data.info.battery.sz_voltage, "%d.%d%dV", readen / 100, (readen / 10) % 10, readen % 10);
	}

	//     
#ifndef WIN32
	if (data.info.signal.air_patch) {
		DL_DbFeatureGetCurrentState(SEEM004A + 0xB, &data.info.signal.airplane);
		data.info.signal.airplane = !data.info.signal.airplane;
	} else {
		DL_DbFeatureGetCurrentState(SEEM004A + 0x211, &data.info.signal.airplane);
	}
#else
	data.info.signal.airplane = false;
#endif

	//   
#ifndef WIN32
	DL_DbFeatureGetCurrentState(SEEM004A + 0x4E, &data.info.bluetooth.power);
#else
	data.info.bluetooth.power = random(2);
#endif
	if (data.info.bluetooth.power) {
	    if (data.info.bluetooth.status == BTS_CONNECTED) { hBTIcon.frame = 2; } else { hBTIcon.frame = 1; }
    } else {
        hBTIcon.frame = 0;
    }

	//   
	prev = data.info.signal.data.dbm;
#ifdef WIN32
	data.info.signal.data.percent = random(100);
	data.info.signal.data.dbm = -103 + random(50);
#else
	DL_SigRegQuerySignalStrength(&data.info.signal.data);
#endif
	if (prev != data.info.signal.data.dbm) {
		if (data.info.signal.airplane) {
			data.info.signal.data.percent = 0;
			hSigIcon.frame = 0;
			sprintf(data.info.signal.sz_dbm, "RF OFF");
		} else {
			data.info.signal.data.percent = (((data.info.signal.data.dbm > data.info.signal.min) ? ( (data.info.signal.data.dbm < data.info.signal.max) ? 100*(data.info.signal.data.dbm - data.info.signal.min)/(data.info.signal.max - data.info.signal.min) : 100 ) : 0) + data.info.signal.data.percent) / 2;
			hSigIcon.frame = ((data.info.signal.data.percent + 10) / 20) + 1;
			sprintf(data.info.signal.sz_dbm, "%ddBm", data.info.signal.data.dbm);
		}
		//     
		sprintf(data.info.signal.sz_percent, "%d%%", data.info.signal.data.percent);
	}

	//   
	GetNextAlarm(now(), &readen, &prev);
	if ((readen != data.info.alarm.time)||(prev != data.info.alarm.active)) {
		data.info.alarm.time = readen;
		data.info.alarm.active = prev;
		//   
		a_time2hm(data.info.alarm.time, data.info.alarm.sz_time);
		//  
		hAlrIcon.frame = data.info.alarm.active;
		//   ,    
		if (!data.info.alarm.active) {
			data.info.alarm.left = 0;
			a_time2hms(data.info.alarm.left, data.info.alarm.sz_left);
		}
	}

	//   
	if (!data.info.drive.predefined) {
#ifndef WIN32
		DL_FsVolumeEnum(data.info.drive.drives);
#else
		u_strcpy(data.info.drive.drives, L"/a /b /c");
#endif
	}
	//   
	prev = data.info.drive.count;
	data.info.drive.count = (u_strlen(data.info.drive.drives) + 1) / 3;
	//  
	if (prev != data.info.drive.count) {
		//  ,      
		if (data.info.drive.data) { mfree(data.info.drive.data); }
		data.info.drive.data = malloc(sizeof(uDriveData) * data.info.drive.count);
		//      (  0xFFFE)
		for (i = 0; i < data.info.drive.count; i++) { data.info.drive.drives[i*3 + 2] = 0; }
	}
	//    
	for (i = 0; i < data.info.drive.count; i++) {
#ifndef WIN32
		DL_FsGetVolumeDescr(&data.info.drive.drives[i*3], &data.info.drive.data[i].desc);
#else
		u_strcpy(data.info.drive.data[i].desc.volume, &data.info.drive.drives[i*3]);	//  
		data.info.drive.data[i].desc.capacity = 1073741824;
		data.info.drive.data[i].desc.free = random(1024) << 20;
		data.info.drive.data[i].desc.device = (random(2)) ? FS_DEVICE_FLASH : FS_DEVICE_TFR ;
#endif
		data.info.drive.data[i].color = GetColorByPercent(data.info.drive.data[i].desc.free, data.info.drive.data[i].desc.capacity);
		//     
		if (data.info.drive.data[i].desc.free) {
			readen = (data.info.drive.data[i].desc.free >> 10) * 1000;
			kb = (readen / 1000) % 1000;
			mb = (readen / 1000000) % 1000;
			gb = readen /1000000000;
			if (readen < 1000000) {
				sprintf(data.info.drive.data[i].sz_space, "%d KB", kb);
			} else if (readen < 1000000000) {
				sprintf(data.info.drive.data[i].sz_space, "%d.%02d MB", mb, kb/10);
			} else {
				sprintf(data.info.drive.data[i].sz_space, "%d.%02d GB", gb, mb/10);
			}
		} else {
			sprintf(data.info.drive.data[i].sz_space, "N/A", mb, kb/10);
		}
	}
	//   \0  0xFFFE
	for (i = 0; i < data.info.drive.count - 1; i++) { data.info.drive.drives[i*3 + 2] = 0xFFFE; }

}






void	GetNextAlarm(UINT32 time, UINT32 *alarm, BOOL *state) {
	ALMCLK_RECORD_T		al;
	UINT32				near_time_on = 0, near_time_off = 0, now_time;
	UINT8				index = 0;

	for (index = 0; index < 10; index++) {
		//     
#ifndef WIN32
		if (!DL_DbAlmclkGetRecordByIndex(index, &al)) {
#else
		al.is_alarm_enabled = true;
		al.time.hour = 18;
		al.time.minute = 12;
#endif
			//   
			now_time = hms2time(al.time.hour, al.time.minute, al.time.second);
			//      ,      
			if (now_time < time) { now_time += 86400000; }

			if (near_time_on) {
				if (al.is_alarm_enabled) {
					if (t_timerdiff(time, now_time) < t_timerdiff(time, near_time_on)) {
						near_time_on = now_time;
					}
				}
			} else {
				if (al.is_alarm_enabled) {
					near_time_on = now_time;
				}
			}

			if (near_time_off) {
				if (!al.is_alarm_enabled) {
					if (t_timerdiff(time, now_time) < t_timerdiff(time, near_time_off)) {
						near_time_off = now_time;
					}
				}
			} else {
				if (!al.is_alarm_enabled) {
					near_time_off = now_time;
				}
			}
#ifndef WIN32
		}
#endif
	}

	//  
	*alarm = (near_time_on) ? near_time_on : near_time_off;
	*state = (near_time_on) ? true : false;
}





UINT32	GetColorByPercent(UINT32 half, UINT32 full) {
	UINT32	result, percent;
	UINT8	r = 0, g = 255;

	//  unsigned int
	if (half > 33554432) { half /= 128; full /= 128; }

	percent = (100 * half) / full;

	if (percent < 25) {
		r = 255;
		g = (percent * 255) / 25;
	} else if (percent < 75) {
		r = ((75 - percent) * 255) / 50;
	}

	return ATI_565RGB(r, g, 0);
}
