#ifndef DEFINES_H_INCLUDED
#define DEFINES_H_INCLUDED

typedef struct uPos_tag {
	unsigned int	x, y;
} uPos;

//     ,   /  (    )
typedef struct uBTConnect_tag {
	unsigned long	unknown;
	char			addr[6];
	unsigned short	status;
} uBTConnect;

//       ( ,    )
typedef struct uBTRequest_tag {
	char			unknown1[5];
	char			addr[6];
	char			name[64];
	char			unknown2[5];
} uBTRequest;

typedef struct uPosData_tag {
	uPos			bluetooth;
	uPos			stopwatch;
	uPos			battery;
	uPos			signal;
	uPos			alarm;
	uPos			drive;
} uPosData;

//   
typedef struct uBattValue_tag {
	unsigned char	vltg;
	char			percent;
	UINT32			timestamp;
} uBattValue;

typedef struct uBattData_tag {
	BOOL			show;
	BOOL			show_icon;
	char			supply, vltg, percent, min, max;
	char			sz_percent[8];
	char			sz_voltage[8];
} uBattData;

//   
typedef struct uSigData_tag {
	BOOL				show;
	BOOL				show_icon;
	signed	char		min, max;
	SIGNAL_STRENGTH_T	data;
	BOOL				airplane;
	BOOL				air_patch;
	char				sz_percent[8];
	char				sz_dbm[8];
} uSigData;

// 
typedef struct uStwData_tag {
	BOOL			show;
	BOOL			show_icon;
	UINT8			key;
	UINT32			timestamp, timems;
	BOOL			started;
	char			sz_time[14]; // 00:00:00.000
} uStwData;

//   
typedef struct uBTData_tag {
	BOOL			show;
	BOOL			show_icon;
	char			addr[6];
	char			sz_addr[20];
	char			power;
	unsigned short	status;
} uBTData;

//   
typedef struct uAlrData_tag {
	BOOL			show;
	BOOL			show_icon;
	BOOL			active;
	UINT32			time;
	char			sz_time[6]; // 00:00
	UINT32			left;
	char			sz_left[10]; // 00:00:00
} uAlrData;

//     
typedef struct uDriveData_tag {
	VOLUME_DESCR_T	desc;
	UINT32			color;
	char			sz_space[12];
} uDriveData;

//      
typedef struct uDrvFreeData_tag {
	BOOL			show;
	BOOL			show_icons;
	BOOL			predefined;
	WCHAR			drives[32];
	uDriveData		*data;
	char			count;
} uDrvFreeData;

//  
typedef struct uInfoData_tag {
	uBTData			bluetooth;
	uStwData		stopwatch;
	uBattData		battery;
	uSigData		signal;
	uAlrData		alarm;
	uDrvFreeData	drive;
} uInfoData;

typedef struct uAppData_tag {
	uPosData		pos;
	uInfoData		info;
} uAppData;

enum {
	BTS_DISCONNECTED = 0,
	BTS_CONNECTED = 0x100
} BT_STATUS_T;

#endif // DEFINES_H_INCLUDED
