#ifndef CFG_H_INCLUDED
#define CFG_H_INCLUDED

#include <typedefs.h>

typedef struct _uCfgString {
	char	*str;
	int		len;
} uCfgString;

typedef struct _uCfgParam {
	uCfgString			param, value;
	struct	_uCfgParam	*prev, *next;
} uCfgParam;

typedef struct _uCfg {
	char		*start;
	char		*end;
	uCfgParam	*fparam, *lparam;
} uCfg;

#ifdef __cplusplus
extern "C" {
#endif

UINT32	cfgOpen(uCfg *cfg, const WCHAR *path);
UINT32	cfgSave(uCfg *cfg, const WCHAR *path);
UINT32	cfgClose(uCfg *cfg);

UINT32	cfgSetParam(uCfgParam *cfgp, char *param, char *value);
UINT32	cfgFreeParam(uCfgParam *cfgp);

char*	cfgGetValue(uCfg *cfg, char *param, char *def);		//        OK.   -    def.
INT32	cfgGetValueInt(uCfg *cfg, char *param, INT32 def);
UINT32	cfgGetValueUInt(uCfg *cfg, char *param, INT32 def);
BOOL	cfgGetValueBool(uCfg *cfg, char *param, BOOL def);

char*	cfgSetValue(uCfg *cfg, char *param, char *value);	//     value   OK.   -  NULL.

void	cfgDisplay(uCfg *cfg);

#ifdef __cplusplus
}
#endif

#endif // CFG_H_INCLUDED
