#include <loader2.h>
#include <mem.h>
#include <utilities.h>

#include "misc.h"
#include "cfg.h"



const char	_true[5] = {'t', 'r', 'u', 'e', 0}, _false[6] = {'f', 'a', 'l', 's', 'e', 0};
char		strip[] = {32, 0};			// ,      
char		replace[] = {9, 0};			// ,  
char		exclude[] = {11, 13, 0};	// ,  



UINT32	cfgOpen(uCfg *cfg, const WCHAR *path) {
	UINT32		result = RESULT_OK, readen = 0;
	uCfgParam	*pparam = NULL, *cparam = NULL;
	char		*data, *param = NULL, *separator = NULL, *value = NULL, *comment = NULL;
	int			i;

	if (cfg) {
		//  
		cfg->fparam = cfg->lparam = NULL;
		cfg->start = w_fsread(path, 0, &readen);
		//     ,   
		if (readen) {
			//  
			for (i = 0; exclude[i]; i++) { a_trim(cfg->start, exclude[i]); }
			//  
			for (i = 0; replace[i]; i++) { a_replace(cfg->start, replace[i], ' '); }
			//    
			cfg->end = cfg->start + strlen(cfg->start);
			//  
			for (data = cfg->start; data <= cfg->end; data++) {
				switch (*data) {
					case ' ':	break;
					case '=':
						//  
						if (!separator) { separator = data; }
						break;
					case ';':
						//  ,    
						if (!comment) { comment = data; }
						break;
					case '\0':
					case '\n':
						//     0,   
						if (separator) { *separator = '\0'; }
						//     0,   
						if (comment) { *comment = '\0'; }
						//     0
						*data = '\0';
						//   ,   ...
						if (param && separator && value && (!comment || (comment && comment > value))) {
							//     uCfgParam   
							cparam = _alloc(sizeof(uCfgParam));
							memclr(cparam, sizeof(uCfgParam));
							//    
							a_rtrim(param, ' ');
							//    
							a_rtrim(value, ' ');
							//   
							cfgSetParam(cparam, param, value);
							cparam->prev = pparam;
							cparam->next = NULL;
							//   ,     ,   -  
							if (pparam) { pparam->next = cparam; } else { cfg->fparam = cparam; }
							//       
							cfg->lparam = cparam;
							pparam = cparam;
						}
						//  
						value = separator = param = comment = NULL;
						break;
					default:
						//    
						if (!comment) {
							//    ,     
							if (!value && param && separator) { value = data; }
							//    , , 
							if (!param && !separator && !value) { param = data; }
						}
				}
			}
			//     
			_free(cfg->start);
			cfg->start = cfg->end = NULL;
		}
	} else {
		result = RESULT_FAIL;
	}

	return result;
}



UINT32	cfgSave(uCfg *cfg, const WCHAR *path) {
	UINT32		result = RESULT_OK, written = 0;
	uCfgParam	*cparam;
	char		*buf;

	if (cfg) {
		//      
		cparam = cfg->fparam;
		while (cparam) {
			written += cparam->param.len + cparam->value.len + 2;	// 2   2 : =  LF
			cparam = cparam->next;
		}
		//    
		buf = _alloc(written + 1);
		//    
		*buf = 0;
		//    
		cparam = cfg->fparam;
		while (cparam) {
			sprintf(buf, "%s%s=%s\n", buf, cparam->param.str, cparam->value.str);
			cparam = cparam->next;
		}
		w_fswrite(path, buf, 0, &written);
		_free(buf);
	} else {
		result = RESULT_FAIL;
	}

	return result;
}



UINT32	cfgClose(uCfg *cfg) {
	UINT32		result = RESULT_OK;

	if (cfg) {
		//    
		if (cfg->start) { _free(cfg->start); }
		//     
		while (cfg->fparam) {
			cfg->lparam = cfg->fparam->next;
			cfgFreeParam(cfg->fparam);
			_free(cfg->fparam);
			//    
			cfg->fparam = cfg->lparam;
		}
		//  
		cfg->fparam = cfg->lparam = NULL;
		cfg->start = cfg->end = NULL;
	}

	return result;
}




UINT32	cfgSetParam(uCfgParam *cfgp, char *param, char *value) {
	UINT32		result = RESULT_OK;
	int			len;

	if (cfgp && param && value) {
		//  
		len = strlen(param);
		if (!cfgp->param.str) {
			//    -  
			cfgp->param.len = len;
			cfgp->param.str = _alloc(cfgp->param.len + 1);
			strcpy(cfgp->param.str, param);
		} else {
			//      
			if (strcmp(cfgp->param.str, param)) {
				if (len > cfgp->param.len) {
					_free(cfgp->param.str);
					cfgp->param.len = len;
					cfgp->param.str = _alloc(cfgp->param.len + 1);
				}
				strcpy(cfgp->param.str, param);
			}
		}
		//  
		len = strlen(value);
		if (!cfgp->value.str) {
			//    -  
			cfgp->value.len = len;
			cfgp->value.str = _alloc(cfgp->value.len + 1);
			strcpy(cfgp->value.str, value);
		} else {
			//  ,   
			if (strcmp(cfgp->value.str, value)) {
				if (len > cfgp->value.len) {
					_free(cfgp->value.str);
					cfgp->value.len = len;
					cfgp->value.str = _alloc(cfgp->value.len + 1);
				}
				strcpy(cfgp->value.str, value);
			}
		}
	}

	return result;
}

UINT32	cfgFreeParam(uCfgParam *cfgp) {
	UINT32		result = RESULT_OK;

	if (cfgp) {
		_free(cfgp->param.str);	cfgp->param.str = NULL;
		_free(cfgp->value.str);	cfgp->value.str = NULL;
	}

	return result;
}




char*	cfgGetValue(uCfg *cfg, char *param, char *def) {
	char		*result = def;
	uCfgParam	*cparam;

	if (cfg) {
		cparam = cfg->fparam;
		while (cparam) {
			if (!strcmp(cparam->param.str, param)) {
				result = cparam->value.str;
				break;
			}
			cparam = cparam->next;
		}
	}

	return result;
}

INT32	cfgGetValueInt(uCfg *cfg, char *param, INT32 def) {
	INT32		result = def;
	char 		*start, *end;

	start = cfgGetValue(cfg, param, NULL);
	if (start) { result = strtol(start, &end, 0); }

	return result;
}

UINT32	cfgGetValueUInt(uCfg *cfg, char *param, INT32 def) {
	UINT32		result = def;
	char 		*start, *end;

	start = cfgGetValue(cfg, param, NULL);
	if (start) { result = strtoul(start, &end, 0); }

	return result;
}

BOOL	cfgGetValueBool(uCfg *cfg, char *param, BOOL def) {
	UINT32		result = def;
	char 		*start;

	start = cfgGetValue(cfg, param, NULL);
	if (start) {
		if (!strcmp(start, _true)) { result = true; } else { result = false; }
	}

	return result;
}

char*	cfgSetValue(uCfg *cfg, char *param, char *value) {
	char		*result = NULL;
	uCfgParam	*cparam;

	if (cfg) {
		cparam = cfg->fparam;
		while (cparam) {
			if (!strcmp(cparam->param.str, param)) {
				cfgSetParam(cparam, param, value);
				result = value;
				break;
			}
			cparam = cparam->next;
		}
		//     ,  
		if (!result) {
			//     uCfgParam
			cparam = _alloc(sizeof(uCfgParam));
			memclr(cparam, sizeof(uCfgParam));
			//   
			cfgSetParam(cparam, param, value);
			//  ...
			if (!cfg->fparam) {
				// ...   
				cfg->fparam = cparam;
			}
			if (cfg->lparam) {
				// ...   
				cfg->lparam->next = cparam;
			}
			cparam->prev = cfg->lparam;
			cparam->next = NULL;
			cfg->lparam = cparam;
		}
	}

	return result;
}




void	cfgDisplay(uCfg *cfg) {
	uCfgParam	*cparam;

	if (cfg) {
		cparam = cfg->fparam;
		while (cparam) {
			cprintf("%s[%d] = %s\n", cparam->param.str, cparam->value.len, cparam->value.str);
			cparam = cparam->next;
		}
	}
}
