#include "AutoWebSes.h"
#define VERSION betta
#define DEBUG 1



UINT32	evcode_base;

SU_PORT_T     port;
APP_HELLOWORLD_T* my_app;

/*  .        */
const char app_name[APP_NAME_LEN] = "AutoWebSes"; 

UINT8 key_pressed = 0;
UINT8 key_relesed = 0;
UINT8 key_long_pressed = 0;
UINT8 timer1_on = 0;

WCHAR spn[20] = L"";
char aspn[20];
WCHAR log_file[] = L"file://b/AutoWebSes.log";

UINT8 ind;
UINT32 status;
char buf[33];
FILE_HANDLE_T fh;
UINT32 wr;
	
char nameCfgFile[64];

//   
BOOL exitN1;
BOOL exitN2;
BOOL exitN3;

UINT8 keyexitN1;
UINT8 keyexitN2;
UINT8 keyexitN3;


//     state-

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { EV_KEY_PRESS,             HandleKeypress },
//	{ EV_KEY_RELEASE,         HandleKeyrelease },
	{ EV_TIMER_EXPIRED,       		     Timer },
	{ EVENT_NPN_CHANGE,		HandleNetworkStatus},

    //      
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};

UINT32 MainJob()
{
	if (DL_FsSGetFileSize(log_file, 0) > 10*1024)
	{
		DL_FsDeleteFile(log_file, 0);
	}
	fh = DL_FsOpenFile(log_file, FILE_APPEND_PLUS_MODE, 0);
	
	
	status = DL_DbWebSessionsFindAbsIndexByName(spn, &ind, 4);
	
	sprintf(buf, "FindAbsIndex: spn=%s, status=%d, index=%d\n", aspn, status, ind);
	dbg("%s\n", buf);
	DL_FsWriteFile(buf, 1, strlen(buf), fh, &wr);
	
	if (0 == status || 1 == status)
	{
		dbg("DL_DbWebSessionsFindAbsIndexByName(%s) success, ind=%d\n", aspn, ind);
		
		if (1 == DL_DbWebSessionsSetDefaultSessionIndex(&port, ind))
		{
			dbg("DL_DbWebSessionsSetDefaultSessionIndex(%d) success\n", ind);
			sprintf(buf, "SetDefaultSession by index=%d success\n", ind);
			DL_FsWriteFile(buf, 1, strlen(buf), fh, &wr);
			
			//destroyApp(ev_st, app);
		}
		else
		{
			dbg("DL_DbWebSessionsSetDefaultSessionIndex(%d) fail\n", ind); 
		}
	}
	else if (2 == status)
	{
		if (timer1_on)
			APP_UtilStopTimer( my_app );
		
		timer1_on = 1;
		APP_UtilStartTimer(5*1000,  0,  my_app );  // 0 -   
	}
	else if (4 == status)
	{
		sprintf(buf, "FindAbsIndex: spn not found\n");
		dbg("%s", buf);
		DL_FsWriteFile(buf, 1, strlen(buf), fh, &wr);
	}
	else
	{
		dbg("DL_DbWebSessionsFindAbsIndexByName(%s) fail\n", aspn); 
	}
	
	DL_FsCloseFile(fh);
	
	return status;
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
	
	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 0) //     ?
	{
		dbg("Timer Tic..., Id=%d\n", 0);
		
		MainJob();
		
		APP_ConsumeEv(ev_st, app );
	}
	
	return RESULT_OK;
}



UINT32 HandleNetworkStatus( EVENT_STACK_T *ev_st,  void *app )
{
	EVENT_T     *event = AFW_GetEv(ev_st);
	char* att = event->attachment;
	UINT32 len;
	
	
	dbg("event_code = %x\n", event->code); 
	
	if (att)
	{
		/*PFprintf("*ELF TEST* attachment[] = "); 
		for (int i=0; i < event->att_size; i++)
		{
			PFprintf("%02x", att[i]);
		}
		PFprintf("\n");*/
		
		
		if ((len = u_strlen((WCHAR*)att)) > 0)
		{
			u_strcpy(spn, (WCHAR*)att);
			u_utoa(spn, aspn);
			
			MainJob();
		}
	}
	
	return RESULT_OK;
}




/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
	int i;
	
    evcode_base = reserve;    //  reserve
    
	

/*   */
    status = APP_Register( &evcode_base,            //      
                           1,                       // - ,     
                           state_handling_table,    //  
                           HW_STATE_MAX,            //  
                           (void*)startApp );   // ,   
                 
				 
	//   
	for (i=0; i < strlen(file_uri)-3; i++)
	{
		nameCfgFile[i] = file_uri[i];
	}
	
	strcat(nameCfgFile, "cfg");
	
	DL_FsDeleteFile(log_file, 0);

		
    LdrStartApp(reserve);   //  
	
    
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
    
	WCHAR buf[64];
	UINT8 bufR[9];
	UINT32 readen;
	FILE_HANDLE_T f;
    

    /* ,    ? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; //     
    }
    else
    {
        //    
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //    
                                                  sizeof(APP_HELLOWORLD_T), //   
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  

        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );
		

	//    		
		if (DL_FsFFileExist( u_atou(nameCfgFile, buf)) == TRUE ) //    
		{
			f = DL_FsOpenFile(u_atou(nameCfgFile, buf), FILE_READ_MODE, 0);
			DL_FsReadFile( bufR, 9, 1, f, &readen );
			DL_FsCloseFile(f);
			
				keyexitN1 = bufR[6];
				keyexitN2 = bufR[7];
				keyexitN3 = bufR[8];
		}
    }

    return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

	if (timer1_on)
		APP_UtilStopTimer( app );

    /*    */
    status = APP_Exit( ev_st, app, NULL );

    /*   */
    LdrUnloadELF(&Lib); // &Lib    

    return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
	port=((APPLICATION_T*)(app))->port; //   
	my_app = app;
	
	return RESULT_OK;
}


	
/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
	UINT8       keypress;
	
	
	keypress = event->data.key_pressed;
	

	if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
	{
		if (exitN1)
		{
			if (exitN2)
			{
				if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
			}
			else
			{
				if (keypress == keyexitN2) exitN2 = TRUE;
			}
		}
		else
		{
			if (keypress == keyexitN1) exitN1 = TRUE;
		}
		if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
		{
			exitN1 = FALSE;
			exitN2 = FALSE;
			exitN3 = FALSE;
		}
	}	
	
	if(exitN1 & exitN2 & exitN3 ) return destroyApp(ev_st, app);

	return RESULT_OK;
}

