#include "ic35sdk.h"

#define SIZE 13
#define MAX_BUFFER_SIZE 128
#define EINTR 10

extern unsigned char card[14];
extern unsigned char cardname[13];
extern BOOL LMark[MAX_BUFFER_SIZE];
extern BOOL RMark[MAX_BUFFER_SIZE];
extern unsigned char LDir[MAX_BUFFER_SIZE];
extern unsigned char RDir[MAX_BUFFER_SIZE];
extern unsigned char Filename[13];
extern unsigned char cText[MAX_BUFFER_SIZE];
extern unsigned char result,LMarkNum,RMarkNum;
extern unsigned char data[1024];
extern unsigned char nL,nR,LeftMax,RightMax;

extern unsigned char Filesize[7];
extern U8 Filedate[8];

extern BOOL cerr;
extern BOOL LeftWin;
extern BOOL Directory;
extern BOOL IsBitMap;

void CardErr(U8 err[128]);
void WhichCard();
void InitAll();
void InitialCard();
void GetDirectorySubItem(BOOL LW);
void GetDirectorySubItemNum(BOOL LW);
void WinInit(BOOL LW);
void CreateDirectory();
void DeleteDirectory();
void DelFile(U8 DelName[MAX_BUFFER_SIZE]);
void DeleteFile();
void RenameDirectory();
void RenFile(U8 OrgFile[MAX_BUFFER_SIZE],U8 RenFileN[MAX_BUFFER_SIZE]);
void RenameFile();
void CpyFile(U8 OrgFile[MAX_BUFFER_SIZE],U8 CopyFileN[MAX_BUFFER_SIZE],U8 FilenameN[13]);
void CopyFile();
void cCut23();
void ViewFile();


void cMain(void)
{

	U8  hText[128];
	U8  n,h,ret;
	U8  LeftB,RightB,LeftMMC,RightMMC;
	BOOL MMC1,MMC2;
	U8  iText[MAX_BUFFER_SIZE];

    unsigned short input,exit; 


	//SetPowerMode(0);					// disables auto power off
	SetKeyTone(0);                      // sets the keyboard tone off
	SetFontMode((U8)NORMAL_FONT);		// sets the font to be used for text output
	FillScreen((U8)WHITE);				// clear screen
	MMC1=FALSE;						    // MMC1 nicht vorhanden
	MMC2=FALSE;                         // MMC2 nicht vorhanden

	DrawRectangle(1,2,13,119,123,0);
    DrawRectangle(1,120,13,119,123,0);
	strcpy(cText," 1=INFO 2=CARD 3=VIEW 5=COPY 6=REN 7=MDIR 8=DEL 0=EXIT");
	WriteText((U8)WHITE,cText,2,LCD_HEIGHT-11);


    strcpy(card,"MMCard1\\");
    strcpy(cardname,"MMCard1");
	InitialCard( );
	if (cerr) MMC1=FALSE;
		else MMC1=TRUE;
	
	strcpy(card,"MMCard2\\");
    strcpy(cardname,"MMCard2");
	InitialCard( );
	if (cerr) MMC2=FALSE;
		else MMC2=TRUE;

	if (MMC1==FALSE) 
	  if(MMC2==FALSE)
	{strcpy(cText,"Keine MMC-Karte vorhanden ! Abbruch !");
	 ret=StringDialogBox(cText,OK);
	return;}

    nL=0;								// Hier werden die Variablen initialisiert!
	nR=0;
	LMarkNum=0;
	RMarkNum=0;
	LeftB=0;
	RightB=0;
	LeftMax=0;
	RightMax=15;
	LeftWin=TRUE;

	if (MMC2==TRUE) 
		{BackupLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	    WhichCard();
		RestoreLcd(1,1,LCD_WIDTH,LCD_HEIGHT);}
	else {strcpy(card,"MMCard1\\");
	strcpy(cardname,"MMCard1");}

	/*InitialCard( );

	strcpy(LDir,card);
	n=strlen(LDir)-1;
	LDir[n]=0x00;
	//if (MMC2==TRUE) strcpy(RDir,"MMCard2");
	//else
	strcpy(RDir,LDir);
	
	WriteText((U8)BLACK,LDir,5,1);
    WriteText((U8)BLACK,RDir,123,1);
    InverseBlock(3,1,116,11);

	GetDirectorySubItemNum(LeftWin);
	LeftMax=result;
	GetDirectorySubItemNum(!LeftWin);
	RightMax=result;

	WinInit(FALSE);
	WinInit(TRUE);*/

	InitAll();

	strcpy(iText,"MMCommander v0.2  \xA9 02.01.2002 croesoft");
	ret=StringDialogBox(iText,OK);

    nL=0;
	nR=0;
    do									// Hauptschleife wird mit "0"=ENDE unterbrochen!! 
	{exit=0;
	do									// Befehlsschleife...
	{
	if (LeftWin==TRUE)				    
    {if (LMark[nL]==TRUE) strcpy(cText,"\x10");
				else strcpy(cText,"   ");
	 WriteText((U8)BLACK,cText,5,15+(nL-LeftB)*12);
	 InverseBlock(5,(15+(nL-LeftB)*12),113,11);
	 FillBlock(0,4,LCD_HEIGHT-23,LCD_WIDTH-8,12);
	 itoa(LMarkNum,hText,10);
	 strcpy(cText,hText);
	 strcat(cText," von ");
	 if (strlen(LDir)>8) itoa(LeftMax-1,hText,10);
	 else itoa(LeftMax,hText,10);
	 strcat(cText,hText);
	 strcat(cText," Dat. markiert");
     WriteText((U8)BLACK,cText,5,137);}
	else
    {if (RMark[nR]==TRUE) strcpy(cText,"\x10");
				else strcpy(cText,"   ");
	 WriteText((U8)BLACK,cText,124,15+(nR-RightB)*12);
	 InverseBlock(123,(15+(nR-RightB)*12),113,11);
	 FillBlock(0,4,LCD_HEIGHT-23,LCD_WIDTH-8,12);
	 itoa(RMarkNum,hText,10);
	 strcpy(cText,hText);
	 strcat(cText," von ");
	 if (strlen(RDir)>8) itoa(RightMax-1,hText,10);
	 else itoa(RightMax,hText,10);
	 strcat(cText,hText);
	 strcat(cText," Dat. markiert");
     WriteText((U8)BLACK,cText,123,137);}
    //FillBlock(0,4,LCD_HEIGHT-24,LCD_WIDTH-8,12);
    FillBlock(0,1,1,LCD_WIDTH,12);
    strcpy(cText,LDir);
	cCut23();
	WriteText((U8)BLACK,cText,5,1);
    strcpy(cText,RDir);
	cCut23();
	WriteText((U8)BLACK,cText,123,1);
	
	//WriteText((U8)BLACK,LDir,5,1);
	//WriteText((U8)BLACK,RDir,123,1);
	if (LeftWin==TRUE) InverseBlock(3,1,116,11);
		else InverseBlock(121,1,116,11);
	input=GetKey( );
	if (LeftWin==TRUE)
    InverseBlock(5,(15+(nL-LeftB)*12),113,11); 
	else
    InverseBlock(123,(15+(nR-RightB)*12),113,11); 
	itoa(input,hText,16);
    //if (show) WriteText((U8)BLACK,hText,0,135);
	//     else WriteText((U8)BLACK,"  ",0,135);
	if ((input==0x30) || (input==0x12)) exit=1;

	if (LeftWin==TRUE)					// Nur wenn linkes Fenster!!
	{if (input==0x04) if (nL-LeftB<EINTR-1) {if (nL<LeftMax-1) ++nL;}
	else if (nL<LeftMax-1)
	{++nL;
	 ScrollPageUp(3,15,114,134,12,0);
     result=nL;
	 GetDirectorySubItem(LeftWin);

	 if (Directory==TRUE) strcpy(cText,"   [");
       else strcpy(cText,"   ");
	 strcat(cText,Filename);
	 if (Directory==TRUE) strcat(cText,"]");
	 WriteText((U8)BLACK,cText,6,123);
	 if (Directory==TRUE) strcpy(cText,"<DIR>");
	 else strcpy(cText,Filesize);
	 WriteText((U8)BLACK,cText,80,123);
	 ++LeftB;}
	

	if (input==0x03) if (nL>LeftB) --nL;
	else if (nL>0)
	{--nL;
	 --LeftB;
	 ScrollPageDn(3,15,114,134,12,0);
	 result=nL;
	 GetDirectorySubItem(LeftWin);
	 if (Directory==TRUE) strcpy(cText,"   [");
       else strcpy(cText,"   ");
	 strcat(cText,Filename);
	 if (Directory==TRUE) strcat(cText,"]");
	 WriteText((U8)BLACK,cText,6,15);
	 if (Directory==TRUE) strcpy(cText,"<DIR>");
	 else strcpy(cText,Filesize);
	 WriteText((U8)BLACK,cText,80,15);}}


    if (LeftWin==FALSE)					// und hier das rechte Fenster!!
	{if (input==0x04) if (nR-RightB<EINTR-1) {if (nR<RightMax-1) ++nR;}
	else if (nR<RightMax-1)
	{++nR;
	 ScrollPageUp(122,15,233,134,12,0);
	 result=nR;
	 GetDirectorySubItem(LeftWin);
	 if (Directory==TRUE) strcpy(cText,"   [");
       else strcpy(cText,"   ");
	 strcat(cText,Filename);
	 if (Directory==TRUE) strcat(cText,"]");
	 WriteText((U8)BLACK,cText,125,123);
	 if (Directory==TRUE) strcpy(cText,"<DIR>");
	 else strcpy(cText,Filesize);
	 WriteText((U8)BLACK,cText,199,123);
	 ++RightB;}


	if (input==0x03) if (nR>RightB) --nR;
	else if (nR>0)
	{--nR;
	 --RightB;
	 ScrollPageDn(122,15,233,134,12,0);
	 result=nR;
	 GetDirectorySubItem(LeftWin);
	 if (Directory==TRUE) strcpy(cText,"   [");
       else strcpy(cText,"   ");
	 strcat(cText,Filename);
	 if (Directory==TRUE) strcat(cText,"]");
	 WriteText((U8)BLACK,cText,125,15);
	 if (Directory==TRUE) strcpy(cText,"<DIR>");
	 else strcpy(cText,Filesize);
	 WriteText((U8)BLACK,cText,199,15);}};


    if (input==0x02) LeftWin=FALSE;		// Rechtes Fenster -->
	if (input==0x01) LeftWin=TRUE;		// Linkes Fenster <--

	if (input==0x0d)					// Hier das Verzeichnis wechseln!
	{if (LeftWin==TRUE) 
		{strcpy(hText,LDir);
	     result=nL;}
	 else 
		{strcpy(hText,RDir);
		result=nR;};
	 GetDirectorySubItem(LeftWin);
	 if (Directory==TRUE)
	 	 {if ((Filename[0]==0x2e) && (Filename[1]==0x2e))
				{n=strlen(hText);
		        do
		        if (hText[n]!=0x5c) --n;
		        while ((hText[n]!=0x5c) && (n!=0));
		        if (hText[n]==0x5c)
		        hText[n]=0x00;}
		  else
				{strcat(hText,"\\");
				 strcat(hText,Filename);}
		      if (LeftWin==TRUE) strcpy(LDir,hText);
	      else strcpy(RDir,hText);
		  GetDirectorySubItemNum(LeftWin); 
		  if (LeftWin==TRUE) 
		  {LeftMax=result;
		   WinInit(LeftWin);
		   nL=0;
		   LeftB=0;}
		  else 
			{RightMax=result;
			 WinInit(LeftWin);
			 nR=0;
		     RightB=0;}}
	else
		{FillBlock(1,4,LCD_HEIGHT-23,LCD_WIDTH-8,12);
		 WriteText((U8)WHITE,Filename,12,137);
	     WriteText((U8)WHITE,Filesize,80,137);
		WriteText((U8)WHITE,Filedate,130,137);
		GetKey();}
	}
	if (input==0x37)						//Create Directory
		{CreateDirectory( );
		 GetDirectorySubItemNum(LeftWin);
		 if (LeftWin) 
		 {LeftMax=result;
		 if (LeftMax<EINTR) WinInit(LeftWin);}	
		 else 
		 {RightMax=result;
		 if (RightMax<EINTR) WinInit(LeftWin);}
		 }

    if (input==0x32)						//MMC-Karte whlen
	  if (MMC2==TRUE) 
		{BackupLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	    WhichCard();
		RestoreLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
		InitAll();}

	if (input==0x38)						//Delete Directory or File
		{if (LeftWin==TRUE) 
			     result=nL;
	     else 
		     	 result=nR;
		GetDirectorySubItem(LeftWin);
		if (Directory==TRUE) if ((Filename[0]!=0x2e) && (Filename[1]!=0x2e)) DeleteDirectory( );
		if (Directory==FALSE) DeleteFile( );
		else {if ((LMarkNum>0) && (LeftWin==TRUE)) DeleteFile( );
		if ((RMarkNum>0) && (LeftWin==FALSE)) DeleteFile( );}
		GetDirectorySubItemNum(LeftWin);
		if (LeftWin) 
		  {LeftMax=result;
		   WinInit(LeftWin);
		   nL=0;
		   if (LDir==RDir) WinInit(!LeftWin);
		  LeftB=0;}
		else 
		  {RightMax=result;
		   WinInit(LeftWin);
		   nR=0;
		   if (RDir==LDir) WinInit(!LeftWin);
		  RightB=0;}}


	if (input==0x36)						//Rename Directory or File
		{if (LeftWin==TRUE) 
			     result=nL;
	     else 
		     	 result=nR;
		GetDirectorySubItem(LeftWin);
		if (Directory==TRUE) 
		if ((Filename[0]!=0x2e) && (Filename[1]!=0x2e)) RenameDirectory( );
		if (Directory==FALSE) RenameFile( );
			else {if ((LMarkNum>0) && (LeftWin==TRUE)) RenameFile( );
				 if ((RMarkNum>0) && (LeftWin==FALSE)) RenameFile( );}
		  GetDirectorySubItemNum(TRUE);
		  LeftMax=result;
		  nL=0;
		  LeftB=0;
		  GetDirectorySubItemNum(FALSE);
		  RightMax=result;
		  nR=0;
		  RightB=0;
		  WinInit(LeftWin);
		  WinInit(!LeftWin);}


	if (input==0x35)						//Copy File
		{if (LeftWin==TRUE) 
			     result=nL;
	     else 
		     	 result=nR;
		GetDirectorySubItem(LeftWin);
		//if (Directory==TRUE) 
		//if ((Filename[0]!=0x2e) && (Filename[1]!=0x2e)) RenameDirectory( );
		if ((Directory==FALSE) || ((LMarkNum>0) && (LeftWin==TRUE)) || ((RMarkNum>0) && (LeftWin==FALSE)))
		{CopyFile( );
		  GetDirectorySubItemNum(TRUE);
		  LeftMax=result;
		  nL=0;
		  LeftB=0;
		  GetDirectorySubItemNum(FALSE);
		  RightMax=result;
		  nR=0;
		  RightB=0;
		  WinInit(LeftWin);
		  WinInit(!LeftWin);}
	}



    if (input==0x20)						// Dateien markieren
	{if (LeftWin==TRUE)
	  {	result=nL;
	    GetDirectorySubItem(LeftWin);
        if (Directory==FALSE)  
		{if (LMark[nL]==TRUE) LMark[nL]=FALSE;
		 else LMark[nL]=TRUE;
	   LMarkNum=0;
		for (h=0;h<129;h++)
			if (LMark[h]==TRUE) ++LMarkNum;}}
	  if (LeftWin==FALSE)
	  { result=nR;
	    GetDirectorySubItem(LeftWin);
		  if (Directory==FALSE)
		  {if (RMark[nR]==TRUE) RMark[nR]=FALSE;
			else RMark[nR]=TRUE;
			RMarkNum=0;
			for (h=0;h<129;h++)
				if (RMark[h]==TRUE) ++RMarkNum;}}}

	if (input==0x31) ret=StringDialogBox(iText,OK);  // Informationen

	if (input==0x33)								// View
	{if (LeftWin==TRUE)
	  {	result=nL;
	    GetDirectorySubItem(LeftWin);
        if (Directory==FALSE) ViewFile();}
	 if (LeftWin==FALSE)
	  { result=nR;
	    GetDirectorySubItem(LeftWin);
        if (Directory==FALSE) ViewFile();}
	}

	} while (exit==0);

    strcpy(cText,"MMCommander beenden?");
	ret=StringDialogBox(cText,YESNO);}
    while (ret==IDNO);

	SetPowerMode(1);


}


void CardErr(U8 err[128])

{
	short i;

	MakeWarnTone( );
	i=StringDialogBox(err,OK);
}

void cCut23()

{     
    if (strlen(cText)>23) 
	{cText[20]=0x00;
	strcat(cText,"...");}
	return;
}


void WhichCard()
{
	short			result;
	unsigned char	buffer[MAX_BUFFER_SIZE];

	strcpy(buffer,"MMCard 1^MMCard 2^");
	result=RadioButton(buffer,0,100,50);
	if (result==0)
	{
		strcpy(card,"MMCard1\\");
		strcpy(cardname,"MMCard1");}
	if (result==1)
	{
		strcpy(card,"MMCard2\\");
		strcpy(cardname,"MMCard2");
	}
	return;
}

void InitAll()

{   short ia;
	
	InitialCard( );
  	    strcpy(LDir,card);
	    ia=strlen(LDir)-1;
	    LDir[ia]=0x00;
		strcpy(RDir,LDir);
  	    WriteText((U8)BLACK,LDir,5,1);
        WriteText((U8)BLACK,RDir,123,1);
        InverseBlock(3,1,116,11);
	    GetDirectorySubItemNum(LeftWin);
	    LeftMax=result;
	    GetDirectorySubItemNum(!LeftWin);
	    RightMax=result;
		nL=0;
		nR=0;
	    WinInit(FALSE);
		WinInit(TRUE);
}
void InitialCard()
{
	unsigned char	comm[MAX_BUFFER_SIZE];
	short			i;

	cerr=FALSE;
	i=mInitialCard(cardname);
	strcpy(comm,cardname);
	cerr=FALSE;
	if (i==MMC_ERROR_SUCCESS)
	  strcat(comm," initialized successfull");
	else cerr=TRUE;
	if (i==MMC_ERROR_MMC_INVALID)
	{strcat(comm," invalid");
	strcpy(cardname,"-");}
	if (i==MMC_ERROR_MMC_UNFORMATTED)
	{strcat(comm," was not formated");}
	return;
}

void GetDirectorySubItemNum(BOOL LW)
{
	short			i;
	unsigned char	complete[MAX_BUFFER_SIZE],
					error[MAX_BUFFER_SIZE];
	FILE_IDEN		dir;
	unsigned short	number;

    if (LW) strcpy(complete,LDir);
   	else strcpy(complete,RDir);
	i=mOpenDirectory(complete,OPEN_EXISTING,&dir);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR1 OpnDir ");
		strcat(error,complete);
		CardErr(error);
		return;
	}
	i=mGetDirectorySubItemNum(&dir,&number);
	if (i!=MMC_ERROR_SUCCESS)
	{
		mCloseDirectory(&dir);
		strcpy(error,"ERROR1 GDirSINum ");
		strcat(error,complete);
		CardErr(error);
		return;
	}
	mCloseDirectory(&dir);
	result=number;
}

void GetDirectorySubItem(BOOL LW)
{
	short			i;
	unsigned char	complete[MAX_BUFFER_SIZE],
					error[MAX_BUFFER_SIZE];
	U8              str[2]; 
	FILE_IDEN		dir;
	FILE_INFO		info;
	unsigned short	index, number;
	long			lValue;

	if (LW==TRUE) strcpy(complete,LDir);
	else strcpy(complete,RDir);
	index=(result+1);
	i=mOpenDirectory(complete,OPEN_EXISTING,&dir);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR2 OpnDir ");
		strcat(error,complete);
		CardErr(error);
		return;
	}
	i=mGetDirectorySubItemNum(&dir,&number);
	if (i!=MMC_ERROR_SUCCESS)
	{
		mCloseDirectory(&dir);
		strcpy(error,"ERROR2 GDirSINum ");
		strcat(error,complete);
		CardErr(error);
		return;
	}
	i=mGetDirectorySubItem(&dir,&info,index);
	if (i!=MMC_ERROR_SUCCESS)
	{
		mCloseDirectory(&dir);
		strcpy(error,"ERROR2 GDirSI ");
        strcat(error,complete);
		CardErr(error);
		return;
	}
	mCloseDirectory(&dir);
    strcpy(Filename,info.cFileName);
	if (strlen(info.cExtName)>0) strcat(Filename,".");
	strcat(Filename,info.cExtName);
	ltoa(&info.dwFileSize,Filesize,10);

	if ((info.byAttribute & 16) > 0) Directory=TRUE;
	  else Directory=FALSE;

	IsBitMap=FALSE;
    if ((info.cExtName[0]==0x42) && (info.cExtName[1]==0x4D) && (info.cExtName[2]==0x50)) IsBitMap=TRUE;
	if ((info.cExtName[0]==0x62) && (info.cExtName[1]==0x6D) && (info.cExtName[2]==0x70)) IsBitMap=TRUE;
	lValue=info.wModifyDate & 31;
	if (lValue<10) strcpy(Filedate,"0");
	else strcpy(Filedate,"");
	itoa(lValue,str,10);
	strcat(Filedate,str);
	strcat(Filedate,".");
	lValue=(info.wModifyDate >> 5) & 15;
	if (lValue<10) strcat(Filedate,"0");
	itoa(lValue,str,10);
	strcat(Filedate,str);
	strcat(Filedate,".");
	lValue=(info.wModifyDate >>9) + 80;
	if (lValue>99) lValue=lValue-100;
	if (lValue<10) strcat(Filedate,"0");
	itoa(lValue,str,10);
	strcat(Filedate,str);
	strcat(Filedate," ");
	lValue=(info.wModifyTime >> 11) & 31;
	if (lValue<10) strcat(Filedate,"0");
	itoa(lValue,str,10);
	strcat(Filedate,str);
	strcat(Filedate,":");
	lValue=(info.wModifyTime >> 5) & 63;
	if (lValue<10) strcpy(Filedate,"0");
	itoa(lValue,str,10);
	strcat(Filedate,str);

}


void WinInit(BOOL LW)

{  U8 h,v,u;

    GetDirectorySubItemNum(LW);	
    if (result<EINTR) h=result;
	else h=EINTR;
    if (LW==TRUE) FillBlock(0,3,15,110,119);
	  else FillBlock(0,121,15,110,119); 
   	for (v=0;v<h;v++)
	{result=v;
	 GetDirectorySubItem(LW);
	 if (Directory==TRUE) strcpy(cText,"   [");
       else strcpy(cText,"   ");
	 strcat(cText,Filename);
	 if (Directory==TRUE) strcat(cText,"]");
	 if (LW==TRUE) WriteText((U8)BLACK,cText,6,(15+v*12));
	     else WriteText((U8)BLACK,cText,125,(15+v*12));
	 if (Directory==TRUE) strcpy(cText,"<DIR>");
	 else strcpy(cText,Filesize);
	 if (LW==TRUE) WriteText((U8)BLACK,cText,80,(15+v*12));
    	 else WriteText((U8)BLACK,cText,199,(15+v*12));}
	if (LW==TRUE) {for (u=0;u<129;u++) LMark[u]=FALSE;
					LMarkNum=0;}
	else {for (u=0;u<129;u++) RMark[u]=FALSE;
			RMarkNum=0;}
}

void CreateDirectory()
{
	short			i, j;
	unsigned char	dirname[13],
					complete[MAX_BUFFER_SIZE],
					error[MAX_BUFFER_SIZE];
	FILE_IDEN		dir;

	if (LeftWin==TRUE) strcpy(complete,LDir);
	else strcpy(complete,RDir);
	strcpy(cText,"Neues Verzeichnis (");
	strcat(cText,complete);
	strcat(cText,"\\)");
	strcpy(dirname,"");
	do
	{
		j=InputControl(cText,dirname,0,13,20,60,208,0);
		if (j==FALSE) return;
	}while(!dirname[0]);
	strcat(complete,"\\");
	strcat(complete,dirname);
	i=mOpenDirectory(complete,CREATE_ALWAYS,&dir);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR3 OpnDir ");
		strcat(error,complete);
		CardErr(error);
		return;
	}
	mCloseDirectory(&dir);
}

void DeleteDirectory()

{
	short			i;
	unsigned char	complete[MAX_BUFFER_SIZE],
					error[MAX_BUFFER_SIZE];
	FILE_IDEN		dir;

	if (LeftWin==TRUE) strcpy(complete,LDir);
	else strcpy(complete,RDir);
    
	strcpy(cText,"Verzeichnis ");
	strcat(cText,Filename);
	strcat(cText," l\xF6schen?");
	
	i=StringDialogBox(cText,YESNO);

	if (i==IDYES)
	{strcat(complete,"\\");
	 strcat(complete,Filename);
	i=mOpenDirectory(complete,OPEN_EXISTING,&dir);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR4 OpnDir ");
		strcat(error,complete);
		CardErr(error);
		return;
	}
	mCloseDirectory(&dir);
	i=mDeleteDirectory(complete);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR DelDir ");
		strcat(error,complete);
		CardErr(error);
		return;
	}}
}


void DelFile(U8 DelName[MAX_BUFFER_SIZE])

{
	short i;
	FILE_IDEN		fileid;
	unsigned char	error[MAX_BUFFER_SIZE];

	i=mOpenFile(DelName,OPEN_EXISTING,&fileid);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR4 OpnFile ");
		strcat(error,DelName);
		CardErr(error);
		return;
	}
	mCloseFile(&fileid);
	i=mDeleteFile(DelName);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR4 DelFile ");
		strcat(error,DelName);
		CardErr(error);
		return;
	}
}

void DeleteFile()

{
	short			i;
	BOOL            Mark;
    unsigned char	Lname[13];
	unsigned char	complete[MAX_BUFFER_SIZE];
	unsigned char   delfiles[MAX_BUFFER_SIZE];
	
	strcpy(Lname,Filename);
	Mark=FALSE;
	if (LeftWin==TRUE) 
	{strcpy(complete,LDir);
	 if (LMarkNum>0) Mark=TRUE;}
	if (LeftWin==FALSE)
	{strcpy(complete,RDir);
	 if (RMarkNum>0) Mark=TRUE;}
    
	if (Mark==TRUE) 
		{if (LeftWin==TRUE) itoa(LMarkNum,cText,10);
		else itoa(RMarkNum,cText,10);
		strcat(cText," markierte Datei(en) l\xF6schen?");}
	else
	{strcpy(cText,"Datei ");
	strcat(cText,Filename);
	strcat(cText," l\xF6schen?");}
	
	i=StringDialogBox(cText,YESNO);

	if (i==IDNO) return;
	if (Mark==FALSE)
		{strcat(complete,"\\");
		strcat(complete,Filename);
		DelFile(complete);}
	if (Mark==TRUE)
		{for (i=128;i>0;i--)
				{strcpy(delfiles,complete);
				strcat(delfiles,"\\");
				if (LeftWin==TRUE) 
					{if (LMark[i]==TRUE)
					{result=i;
					GetDirectorySubItem(LeftWin);
					strcat(delfiles,Filename);
					DelFile(delfiles);}}
				if (LeftWin==FALSE) 
					{if (RMark[i]==TRUE)
					{result=i;
					GetDirectorySubItem(LeftWin);
					strcat(delfiles,Filename);
					DelFile(delfiles);}}}}
}


void RenameDirectory()
{
	short			i,j;
	unsigned char	complete[MAX_BUFFER_SIZE],
					newcomplete[MAX_BUFFER_SIZE],
					error[MAX_BUFFER_SIZE];
	FILE_IDEN		dir;

	
    if (LeftWin==TRUE) 
	{if (LDir==RDir) strcpy(newcomplete,"");
	else strcpy(newcomplete,RDir);}
	else {if (RDir==LDir) strcpy(newcomplete,"");
		  else strcpy(newcomplete,LDir);}
	if (strlen(newcomplete)>0) strcat(newcomplete,"\\");
	strcat(newcomplete,Filename);
	strcpy(cText,"Verzeichnis ");
	strcat(cText,Filename);
	strcat(cText," umbenennen:");
	do
	{
		j=InputControl(cText,newcomplete,0,128,20,60,208,0);
		if (j==FALSE) return;
	}while(!newcomplete[0]);
 

	if (LeftWin==TRUE) strcpy(complete,LDir);
	else strcpy(complete,RDir);
    strcat(complete,"\\");
	strcat(complete,Filename);

	i=mOpenDirectory(complete,OPEN_EXISTING,&dir);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR5 OpnDir ");
		strcat(error,complete);
		CardErr(error);
		return;
	}
	mCloseDirectory(&dir);
	i=mRenDirectory(complete,newcomplete);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR5 RenDir ");
		strcat(error,complete);
		CardErr(error);
		return;
	}
}


void RenFile(U8 OrgFile[MAX_BUFFER_SIZE],U8 RenFileN[MAX_BUFFER_SIZE])

{	
	short i;
	FILE_IDEN		fileid;
	unsigned char	error[MAX_BUFFER_SIZE];

    i=mOpenFile(OrgFile,OPEN_EXISTING,&fileid);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR6 OpnFile ");
		strcat(error,OrgFile);
		CardErr(error);
		return;
	}
	mCloseFile(&fileid);
	i=mRenFile(OrgFile,RenFileN);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR6 RenFile ");
		strcat(error,RenFileN);
		CardErr(error);
		return;
	}
	return;
}

void RenameFile()
{
	short			i,j;
	BOOL            Mark;
	unsigned char	complete[MAX_BUFFER_SIZE],
					newcomplete[MAX_BUFFER_SIZE];

	Mark=FALSE;
	if ((LeftWin==TRUE) && (LMarkNum>0)) Mark=TRUE;
	if ((LeftWin==FALSE) && (RMarkNum>0)) Mark=TRUE;
	if (LeftWin==TRUE) 
	{if (LDir==RDir) strcpy(newcomplete,"");
	else strcpy(newcomplete,RDir);}
	else {if (RDir==LDir) strcpy(newcomplete,"");
		  else strcpy(newcomplete,LDir);}
	if (strlen(newcomplete)>0) strcat(newcomplete,"\\");
	if (Mark==FALSE)
	{
	strcat(newcomplete,Filename);
	strcpy(cText,"Datei ");
	strcat(cText,Filename);
	strcat(cText," umbenennen/bewegen:");
	do
	{
		j=InputControl(cText,newcomplete,0,128,20,60,208,0);
		if (j==FALSE) return;
	}while(!newcomplete[0]);
 

	if (LeftWin==TRUE) strcpy(complete,LDir);
	else strcpy(complete,RDir);
    strcat(complete,"\\");
	strcat(complete,Filename);
	BackupLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	RenFile(complete,newcomplete);
	RestoreLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	return;}
	if (Mark==TRUE)
	{
	strcpy(cText,"Markierte Datei(en) nach ");
	strcat(cText,newcomplete);
	strcat(cText," bewegen?");
	
	j=StringDialogBox(cText,YESNO);
	if (j==IDNO) return;
	BackupLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	for (i=128;i>0;i--)
	{strcpy(complete,LDir);
	 strcat(complete,"\\");
	 strcpy(newcomplete,RDir);
	 strcat(newcomplete,"\\");
	 if (LeftWin==TRUE) 
	 {if (LMark[i]==TRUE)
			{result=i;
			GetDirectorySubItem(LeftWin);
			strcat(complete,Filename);
			strcat(newcomplete,Filename);
			strcpy(cText,Filename);
			strcat(cText," wird umbenannt...");
			Button(cText,50,70,0);
			RenFile(complete,newcomplete);}}
	  if (LeftWin==FALSE) 
	  {if (RMark[i]==TRUE)
			{result=i;
			GetDirectorySubItem(LeftWin);
			strcat(complete,Filename);
			strcat(newcomplete,Filename);
			strcpy(cText,Filename);
			strcat(cText," wird umbenannt...");
			Button(cText,50,70,0);
			RenFile(newcomplete,complete);}}}
	RestoreLcd(1,1,LCD_WIDTH,LCD_HEIGHT);}
	return;
}


/*void ViewBmp()

{   unsigned char	BMPFile[MAX_BUFFER_SIZE];

	if (LeftWin==TRUE) strcpy(BMPFile,LDir);
	else strcpy(BMPFile,RDir);
	strcat(BMPFile,"\\");
	strcat(BMPFile,Filename);
	BackupLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	PutBitmap(BMPFile,1,1);
	RestoreLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	GetKey();
	return;
}*/


void ViewFile()

{   short i,j,c,h,z,updown;
	U8    hout[3];
	U8    hlout[36]; 
	unsigned long   lncnt,fl;
    unsigned char	EdtFile[MAX_BUFFER_SIZE];
	unsigned short  read,inputv; 
	FILE_IDEN		fileid;
	FILE_INFO		fileinfo;

	if (IsBitMap==TRUE)
	{//ViewBmp();
	return;};
	BackupLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	if (LeftWin==TRUE) strcpy(EdtFile,LDir);
	else strcpy(EdtFile,RDir);
	strcat(EdtFile,"\\");
	strcat(EdtFile,Filename);
    i=mOpenFile(EdtFile,OPEN_EXISTING,&fileid);
	mGetFileInfo(&fileid,&fileinfo);
	updown=1;
	lncnt=0;
	do
	{if ((updown==1) && (lncnt<fileinfo.dwFileSize))
	{FillScreen((U8)WHITE);				            // clear screen
	DrawRectangle(1,1,1,LCD_WIDTH-2,LCD_HEIGHT-16,0);
	DrawVerticalLine(1,153,2,LCD_HEIGHT-16,0);
	j=0;
	read=0;
	c=12;}
	
	if ((updown==1) && (lncnt<fileinfo.dwFileSize)) do
	{if (fileinfo.dwFileSize-lncnt>12)
			c=12;
		else
			c=fileinfo.dwFileSize-lncnt;
	mReadFromFile(&fileid,data,c,&read);
	lncnt=lncnt+c;
	strcpy(hlout,"");
	for (h=0;h<c;h++)
	{z=data[h];
	//if (z==0) data[h]=46;
	itoa(z,hout,16);
	strcat(hout," ");
	if (z<16) strcat(hlout,"0");
	strcat(hlout,hout);}
	WriteText((U8)BLACK,hlout,5,8+(j*12));	
	WriteText((U8)BLACK,data,160,8+(j*12));
    ++j;}
	while ((j<11) && (lncnt<fileinfo.dwFileSize));

	FillBlock(0,1,LCD_HEIGHT-12,LCD_WIDTH-2,12);
	strcpy(cText," ESC=END \x19=NXT PG \x18=TOP      Byte/Max: ");
	ltoa(&lncnt,hlout,10);
	strcat(cText,hlout);
	strcat(cText,"/");
	ltoa(&fileinfo.dwFileSize,hlout,10);
	strcat(cText,hlout);
	WriteText((U8)BLACK,cText,2,LCD_HEIGHT-11);
	InverseBlock(1,LCD_HEIGHT-12,LCD_WIDTH-2,12);
	inputv=GetKey();
	updown=0;
	if (inputv==0x04) updown=1;
	if (inputv==0x03) 
	{mCloseFile(&fileid);
	i=mOpenFile(EdtFile,OPEN_EXISTING,&fileid);
	updown=1;
	lncnt=0;}
	}
	while (inputv!=0x12);
	mCloseFile(&fileid);
	RestoreLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
}


void CpyFile(U8 OrgFile[MAX_BUFFER_SIZE],U8 CopyFileN[MAX_BUFFER_SIZE],U8 FilenameN[13])
{
	unsigned long	i;
	short			j,c;
	unsigned char	error[MAX_BUFFER_SIZE];
	FILE_IDEN		fileid1, fileid2;
	FILE_INFO		fileinfo;
	unsigned short	read;
	
    strcat(OrgFile,"\\");
	strcat(OrgFile,FilenameN);
	i=mOpenFile(OrgFile,OPEN_EXISTING,&fileid1);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR7 OpnFile ");
		strcat(error,OrgFile);
		CardErr(error);
		return;
	}

	i=mOpenFile(CopyFileN,CREATE_ALWAYS,&fileid2);
	if (i!=MMC_ERROR_SUCCESS)
	{
		strcpy(error,"ERROR7 OpnFile ");
		strcat(error,CopyFileN);
		CardErr(error);
		mCloseFile(&fileid1);
		return;
	}
	mGetFileInfo(&fileid1,&fileinfo);
    BackupLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	i=0;
	do
	{
		if (fileinfo.dwFileSize-i>1024)
			c=1024;
		else
			c=fileinfo.dwFileSize-i;
		mReadFromFile(&fileid1,data,c,&read);
		j=mWriteToFile(&fileid2,data,c);
		i=i+c;
		strcpy(cText,FilenameN);
		strcat(cText," : ");
		ltoa(&i,error,10);
		strcat(cText,error);
		strcat(cText," Bytes kopiert...");
        Button(cText,50,70,0);
		if (j!=MMC_ERROR_SUCCESS)
			{strcpy(error,"ERROR7 Wrt2File ");
			strcat(error,CopyFileN);
			CardErr(error);
			mCloseFile(&fileid1);
			mCloseFile(&fileid2);
			return;
		}
	}
	while (i<fileinfo.dwFileSize);
	RestoreLcd(1,1,LCD_WIDTH,LCD_HEIGHT);
	mCloseFile(&fileid1);
	mCloseFile(&fileid2);

}


void CopyFile()
{
	short			i,j;
	BOOL            Mark;
	unsigned char	filename[MAX_BUFFER_SIZE],
					complete[MAX_BUFFER_SIZE],
					error[MAX_BUFFER_SIZE],
					//newfilename[MAX_BUFFER_SIZE],
					newcomplete[MAX_BUFFER_SIZE];
					//data[1024];
	
	Mark=FALSE;
	if ((LeftWin==TRUE) && (LMarkNum>0)) Mark=TRUE;
	if ((LeftWin==FALSE) && (RMarkNum>0)) Mark=TRUE;

	if (LeftWin==TRUE) 
	{if (LDir==RDir) strcpy(newcomplete,"");
	else strcpy(newcomplete,RDir);}
	else {if (RDir==LDir) strcpy(newcomplete,"");
		  else strcpy(newcomplete,LDir);}
	if (strlen(newcomplete)>0) strcat(newcomplete,"\\");
	if (Mark==FALSE)
	{
	strcat(newcomplete,Filename);
	strcpy(cText,"Datei ");
	strcat(cText,Filename);
	strcat(cText," kopieren:");
    do
	{
		j=InputControl(cText,newcomplete,0,128,20,60,208,0);
		if (j==FALSE) return;
	}while(!newcomplete[0]);
 

	if (LeftWin==TRUE) strcpy(complete,LDir);
	else strcpy(complete,RDir);
	CpyFile(complete,newcomplete,Filename);
	return;
	}
	if (Mark==TRUE)
	{
	strcpy(cText,"Markierte Datei(en) nach ");
	if (LeftWin) strcat(cText,RDir);
	else strcat(cText,LDir);
	strcat(cText," kopieren?");
	
	j=StringDialogBox(cText,YESNO);
	if (j==IDNO) return;
	for (i=128;i>0;i--)
	{strcpy(complete,LDir);
	 strcpy(newcomplete,RDir);
	 if (LeftWin==TRUE) 
	 {if (LMark[i]==TRUE)
			{result=i;
			GetDirectorySubItem(LeftWin);
			strcat(newcomplete,"\\");
			strcat(newcomplete,Filename);
			CpyFile(complete,newcomplete,Filename);}}
	  if (LeftWin==FALSE) 
	  {if (RMark[i]==TRUE)
			{result=i;
			GetDirectorySubItem(LeftWin);
			strcat(complete,"\\");
			strcat(complete,Filename);
			CpyFile(newcomplete,complete,Filename);}}}}
}

